/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.impl.mem;

import com.ibm.cognos.aurora.core.graph.api.IArc;
import com.ibm.cognos.aurora.core.graph.api.IGraph;
import com.ibm.cognos.aurora.core.graph.api.IGraphChangeListener;
import com.ibm.cognos.aurora.core.graph.api.IVertex;
import com.ibm.cognos.aurora.core.graph.api.IVertexIndex;
import java.util.HashMap;
import java.util.Map;

public class InMemoryVertexIndex
implements IVertexIndex,
IGraphChangeListener {
    private final String mPropertyKey;
    private final Map<Object, IVertex> mValueToVertexMap = new HashMap<Object, IVertex>();

    public InMemoryVertexIndex(String propertyKey) {
        this.mPropertyKey = propertyKey;
    }

    @Override
    public String getPropertyKey() {
        return this.mPropertyKey;
    }

    public void insert(IVertex v) {
        Object propValue = v.getPropertyValue(this.mPropertyKey);
        if (null != propValue) {
            this.mValueToVertexMap.put(propValue, v);
        }
    }

    @Override
    public IVertex lookup(Object value) {
        return this.mValueToVertexMap.get(value);
    }

    public void remove(IVertex v) {
        Object propValue = v.getPropertyValue(this.mPropertyKey);
        if (null != propValue) {
            this.mValueToVertexMap.remove(propValue);
        }
    }

    public void clear() {
        this.mValueToVertexMap.clear();
    }

    public String toString() {
        return this.mValueToVertexMap.toString();
    }

    @Override
    public void onGraphPropertyChanged(IGraph graph, String property, Object oldValue, Object newValue) {
    }

    @Override
    public void onVertexAdded(IVertex vertex) {
        this.insert(vertex);
    }

    @Override
    public void onVertexRemoved(IVertex vertex) {
        this.remove(vertex);
    }

    @Override
    public void onVertexPropertyChanged(IVertex vertex, String property, Object oldValue, Object newValue) {
        if (property.equals(this.mPropertyKey)) {
            if (null != oldValue) {
                this.mValueToVertexMap.remove(oldValue);
            }
            if (null != newValue) {
                this.mValueToVertexMap.put(newValue, vertex);
            }
        }
    }

    @Override
    public void onArcAdded(IArc arc) {
    }

    @Override
    public void onArcRemoved(IArc arc) {
    }

    @Override
    public void onArcPropertyChanged(IArc arc, String property, Object oldValue, Object newValue) {
    }
}

