/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.persist.bin;

import com.ibm.cognos.aurora.api.util.MultiPartIdentifier;
import com.ibm.cognos.aurora.core.graph.persist.bin.IBinaryObjectSerializer;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class BinaryValueSerializer {
    private static final byte NULL = 0;
    private static final byte STRING = 1;
    private static final byte BOOLEAN = 2;
    private static final byte BYTE = 3;
    private static final byte SHORT = 4;
    private static final byte INT = 5;
    private static final byte LONG = 6;
    private static final byte FLOAT = 7;
    private static final byte DOUBLE = 8;
    private static final byte MULTI_PART_ID = 9;
    private static final byte CUSTOM = 127;
    private final Map<Class<?>, IBinaryObjectSerializer> mCustomSerializers = new HashMap();
    private final Map<String, Class<?>> mClassCache = new HashMap();

    public void registerType(Class<?> valueType, IBinaryObjectSerializer serializer) {
        this.mCustomSerializers.put(valueType, serializer);
        this.mClassCache.put(valueType.getName(), valueType);
    }

    public Object readValue(DataInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return EncodeUtil.readString(in);
            }
            case 2: {
                return in.readBoolean();
            }
            case 3: {
                return in.readByte();
            }
            case 4: {
                return in.readShort();
            }
            case 5: {
                return in.readInt();
            }
            case 6: {
                return in.readLong();
            }
            case 7: {
                return Float.valueOf(in.readFloat());
            }
            case 8: {
                return in.readDouble();
            }
            case 9: {
                MultiPartIdentifier id = new MultiPartIdentifier();
                id.decodeBinary(in, null);
                return id;
            }
            case 127: {
                return this.readCustom(in);
            }
        }
        throw new IOException("Unsupported type: " + type);
    }

    private Object readCustom(DataInput in) throws IOException {
        String className = in.readUTF();
        Class<?> klass = this.mClassCache.get(className);
        if (null == klass) {
            throw new IOException("Unsupported class: " + className);
        }
        return this.mCustomSerializers.get(klass).read(in);
    }

    public void writeValue(DataOutput out, Object value) throws IOException {
        if (null == value) {
            out.writeByte(0);
        } else if (value instanceof String) {
            out.writeByte(1);
            EncodeUtil.writeString(out, (String)value);
        } else if (value instanceof Boolean) {
            out.writeByte(2);
            out.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            out.writeByte(3);
            out.writeByte(((Byte)value).byteValue());
        } else if (value instanceof Short) {
            out.writeByte(4);
            out.writeShort(((Short)value).shortValue());
        } else if (value instanceof Integer) {
            out.writeByte(5);
            out.writeInt((Integer)value);
        } else if (value instanceof Long) {
            out.writeByte(6);
            out.writeLong((Long)value);
        } else if (value instanceof Float) {
            out.writeByte(7);
            out.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            out.writeByte(8);
            out.writeDouble((Double)value);
        } else if (value instanceof MultiPartIdentifier) {
            out.writeByte(9);
            ((MultiPartIdentifier)value).encodeBinary(out, null);
        } else {
            out.writeByte(127);
            this.writeCustom(out, value);
        }
    }

    private void writeCustom(DataOutput out, Object value) throws IOException {
        Class<?> klass = value.getClass();
        IBinaryObjectSerializer serializer = this.mCustomSerializers.get(klass);
        if (null == serializer) {
            throw new IOException("Unsupported class: " + klass.getName());
        }
        EncodeUtil.writeString(out, klass.getName());
        serializer.write(out, value);
    }
}

