/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.httphandler;

import com.ibm.cognos.aurora.core.httphandler.RESTException;
import com.ibm.cognos.aurora.core.httphandler.RESTExceptionHandler;
import com.ibm.cognos.aurora.core.httphandler.RESTResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHandler {
    private HttpClient client;
    private CookieStore cookieStore;
    private HttpContext localContext;
    private String mainUrl;
    private Map<String, List<String>> headers;
    private Properties properties;
    private boolean isLocalMode;
    private RESTExceptionHandler exHandler;
    private String genericFailMessage;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHandler.class);

    public HttpHandler(String mainUrl, Map<String, List<String>> headers, Properties properties, CookieStore cookieStore, RESTExceptionHandler exHandler, boolean isLocalMode) {
        if (cookieStore == null) {
            cookieStore = new BasicCookieStore();
        }
        this.isLocalMode = isLocalMode;
        this.headers = headers;
        this.properties = properties;
        this.mainUrl = mainUrl;
        this.cookieStore = cookieStore;
        this.localContext = new BasicHttpContext();
        this.localContext.setAttribute("http.cookie-store", (Object)cookieStore);
        this.client = this.creatHttpClient();
        this.genericFailMessage = "We're sorry. Something went wrong on our side and we're busy fixing the issue. Please try again later.";
        this.exHandler = exHandler;
    }

    public RESTResult makeCallAndFailOnBadResponseCode(HttpRequestBase method, String operationName, String usrMsg) throws RESTException {
        String url = method.getURI().toString();
        RESTResult result = this.executeHelper(method, operationName, usrMsg);
        if (result.getResponseCode() < 200 || result.getResponseCode() >= 300) {
            String devMsg = "Operation: " + operationName + " failed due to respondeCode " + result.getResponseCode() + "\nUrl: " + url + "\n" + this.toString();
            throw this.exHandler.createExceptionFromResponseBody(usrMsg, devMsg, result.getResponseString());
        }
        return result;
    }

    public RESTResult makeCall(HttpRequestBase httpRequest, String operationName) throws RESTException {
        RESTResult result;
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)this.appendHeadersToRequest(httpRequest), this.localContext);
            int responseCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String responseString = entity == null ? "There is no http body" : EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            result = new RESTResult(responseCode, responseString);
        }
        catch (IOException e) {
            throw this.exHandler.createException_IOException(this.genericFailMessage, operationName, e);
        }
        finally {
            httpRequest.releaseConnection();
        }
        return result;
    }

    public void shutdown() {
        this.client.getConnectionManager().shutdown();
    }

    public String toString() {
        return this.toString(null);
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getMainUrl() {
        return this.mainUrl;
    }

    public boolean isLocalMode() {
        return this.isLocalMode;
    }

    public String toString(HttpRequestBase headers) {
        StringBuilder sb = new StringBuilder();
        sb.append("---------------------------\n");
        if (headers != null) {
            sb.append("Headers:\n");
            for (Header h : headers.getAllHeaders()) {
                sb.append(h.toString() + ", ");
            }
        }
        sb.append("\nCookies:\n");
        for (Cookie cookie : this.cookieStore.getCookies()) {
            sb.append(cookie.toString() + ", ");
        }
        sb.append("\nMain Url: " + this.mainUrl);
        sb.append("\n---------------------------\n");
        return sb.toString();
    }

    private RESTResult executeHelper(HttpRequestBase method, String operationName, String usrMsg) throws RESTException {
        RESTResult result;
        long duration;
        this.appendHeadersToRequest(method);
        long startTime = System.nanoTime();
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)method, this.localContext);
            long endTime = System.nanoTime();
            duration = (endTime - startTime) / 1000000000L;
            int responseCode = response.getStatusLine().getStatusCode();
            HttpEntity httpEntity = response.getEntity();
            String responseString = httpEntity != null ? EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8") : "";
            result = new RESTResult(responseCode, responseString);
        }
        catch (IOException e) {
            throw new RESTException(this.genericFailMessage, "IOException was found during operation: " + operationName, e);
        }
        finally {
            method.releaseConnection();
        }
        LOGGER.info("Method: " + operationName + " completed succesfully in " + duration + "(s).");
        return result;
    }

    private HttpClient creatHttpClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpParams params = client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)2000000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)2000000);
        params.setParameter("http.protocol.single-cookie-header", (Object)Boolean.TRUE);
        params.setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        return client;
    }

    private HttpRequestBase addHeaderIfChangeOrMissing(HttpRequestBase httpRequest, String key, String value) {
        Header h1 = httpRequest.getFirstHeader(key);
        while (h1 != null) {
            httpRequest.removeHeader(h1);
            h1 = httpRequest.getFirstHeader(key);
        }
        String safeKey = this.getStringWithoutCLRF(key);
        String safeValue = this.getStringWithoutCLRF(value);
        httpRequest.addHeader(safeKey, safeValue);
        return httpRequest;
    }

    private String getStringWithoutCLRF(String s) {
        return s.replaceAll("[\n\r]", "");
    }

    private HttpRequestBase appendHeadersToRequest(HttpRequestBase httpRequest) {
        if (this.headers != null) {
            for (Map.Entry<String, List<String>> header : this.headers.entrySet()) {
                List<String> valList = header.getValue();
                if (valList.isEmpty()) continue;
                httpRequest = this.addHeaderIfChangeOrMissing(httpRequest, header.getKey(), valList.get(0));
            }
        }
        return httpRequest;
    }

    public RESTExceptionHandler getExceptionHandler() {
        return this.exHandler;
    }
}

