/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;

public final class EncodeUtil {
    private static final String EMPTY_STRING = "";
    private static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    private static final long LONG_LOW_HALF_MASK = 0xFFFFFFFFL;
    private static final int INT_LOW_HALF_MASK = 65535;
    private static final long LONG_HIGH_33_MASK = Integer.MIN_VALUE;
    private static final int INT_HIGH_17_MASK = Short.MIN_VALUE;
    private static final long LONG_MSB_MASK = Long.MIN_VALUE;
    private static final int INT_MSB_MASK = Integer.MIN_VALUE;
    private static final short SHORT_MSB_MASK = Short.MIN_VALUE;

    public static void writeString(DataOutput out, String value) throws IOException {
        out.writeUTF(value);
    }

    public static String readString(DataInput in) throws IOException {
        return in.readUTF();
    }

    public static void writeCompressedLong(DataOutput output, long value) throws IOException {
        if ((value & Long.MIN_VALUE) == Long.MIN_VALUE) {
            throw new IllegalArgumentException("Negtive values cannot be compressed - most significant bit is reserved.");
        }
        if ((value & Integer.MIN_VALUE) == 0L) {
            output.writeInt((int)(value & 0xFFFFFFFFL));
        } else {
            output.writeLong(value | Long.MIN_VALUE);
        }
    }

    public static long readCompressedLong(DataInput input) throws IOException {
        int high = input.readInt();
        if ((high & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            int low = input.readInt();
            return (long)(high & Integer.MAX_VALUE) << 32 | (long)low & 0xFFFFFFFFL;
        }
        return high;
    }

    public static void writeCompressedInt(DataOutput output, int value) throws IOException {
        if ((value & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Negtive values cannot be compressed - most significant bit is reserved.");
        }
        if ((value & Short.MIN_VALUE) == 0) {
            output.writeShort((short)(value & 0xFFFF));
        } else {
            output.writeInt(value | Integer.MIN_VALUE);
        }
    }

    public static int readCompressedInt(DataInput input) throws IOException {
        short high = input.readShort();
        if ((high & Short.MIN_VALUE) == Short.MIN_VALUE) {
            short low = input.readShort();
            return (high & Short.MAX_VALUE) << 16 | low & 0xFFFF;
        }
        return high;
    }

    private EncodeUtil() {
    }
}

