/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.io;

import com.ibm.cognos.aurora.core.io.FileChannelInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileChannelDataInputStream
extends FileChannelInputStream
implements DataInput {
    private final DataInputStream mDataStream = new DataInputStream(this);

    public FileChannelDataInputStream(FileChannel channel) {
        super(channel);
    }

    public FileChannelDataInputStream(FileChannel channel, int bufferSize) {
        super(channel, bufferSize);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            if (!this.ensureBufferRemaining(Math.min(len, this.mBufferCapacity))) {
                throw new EOFException();
            }
            int numRead = this.read(b, off, len);
            if (numRead == -1) {
                throw new EOFException();
            }
            off += numRead;
            len -= numRead;
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        return 0 != this.read();
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    @Override
    public char readChar() throws IOException {
        if (!this.ensureBufferRemaining(2)) {
            throw new EOFException();
        }
        char ch = this.mBuffer.getChar();
        this.mPos += 2L;
        this.mBufferRemaining -= 2;
        return ch;
    }

    @Override
    public double readDouble() throws IOException {
        if (!this.ensureBufferRemaining(8)) {
            throw new EOFException();
        }
        double dbl = this.mBuffer.getDouble();
        this.mPos += 8L;
        this.mBufferRemaining -= 8;
        return dbl;
    }

    @Override
    public float readFloat() throws IOException {
        if (!this.ensureBufferRemaining(4)) {
            throw new EOFException();
        }
        float flt = this.mBuffer.getFloat();
        this.mPos += 4L;
        this.mBufferRemaining -= 4;
        return flt;
    }

    @Override
    public int readInt() throws IOException {
        if (!this.ensureBufferRemaining(4)) {
            throw new EOFException();
        }
        int i = this.mBuffer.getInt();
        this.mPos += 4L;
        this.mBufferRemaining -= 4;
        return i;
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readLong() throws IOException {
        if (!this.ensureBufferRemaining(8)) {
            throw new EOFException();
        }
        long l = this.mBuffer.getLong();
        this.mPos += 8L;
        this.mBufferRemaining -= 8;
        return l;
    }

    @Override
    public short readShort() throws IOException {
        if (!this.ensureBufferRemaining(2)) {
            throw new EOFException();
        }
        short sht = this.mBuffer.getShort();
        this.mPos += 2L;
        this.mBufferRemaining -= 2;
        return sht;
    }

    @Override
    public String readUTF() throws IOException {
        return this.mDataStream.readUTF();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int b = this.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (b1 << 8) + (b2 << 0);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (!this.ensureBufferRemaining(1)) {
            return 0;
        }
        int numSkipped = Math.min(n, this.mBufferRemaining);
        this.position(this.position() + (long)numSkipped);
        return numSkipped;
    }
}

