/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileChannelOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 524288;
    private final FileChannel mChannel;
    private long mChannelPos = 0L;
    protected final ByteBuffer mBuffer;
    protected final long mBufferCapacity;
    protected long mBufferRemaining = 0L;
    protected long mStreamPos = 0L;

    public FileChannelOutputStream(FileChannel channel) {
        this(channel, 524288);
    }

    public FileChannelOutputStream(FileChannel channel, int bufferSize) {
        this.mChannel = channel;
        this.mBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.mBufferRemaining = this.mBufferCapacity = (long)this.mBuffer.capacity();
    }

    public long position() {
        return this.mStreamPos;
    }

    public void position(long newPos) throws IOException {
        this.flushBuffer(true);
        this.mStreamPos = newPos;
        this.mChannelPos = newPos;
    }

    public void reset() throws IOException {
        this.mStreamPos = 0L;
        this.mChannelPos = 0L;
        this.mBuffer.clear();
        this.mBufferRemaining = 0L;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureBufferRemaining(1);
        this.mBuffer.put((byte)(b & 0xFF));
        --this.mBufferRemaining;
        ++this.mStreamPos;
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int start, int length) throws IOException {
        if (start < 0 || length < 0 || start + length > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        while (length > 0) {
            this.ensureBufferRemaining(1);
            int bytesToWrite = (int)Math.min(this.mBufferRemaining, (long)length);
            this.mBuffer.put(buf, start, bytesToWrite);
            this.mBufferRemaining -= (long)bytesToWrite;
            this.mStreamPos += (long)bytesToWrite;
            start += bytesToWrite;
            length -= bytesToWrite;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.flushBuffer(true);
        }
        finally {
            this.mChannel.close();
        }
    }

    protected void ensureBufferRemaining(int minSize) throws IOException {
        while (this.mBufferRemaining < (long)minSize) {
            this.flushBuffer(false);
        }
    }

    private void flushBuffer(boolean allOfIt) throws IOException {
        this.mBuffer.flip();
        do {
            int numWritten = this.mChannel.write(this.mBuffer, this.mChannelPos);
            this.mChannelPos += (long)numWritten;
            this.mBufferRemaining += (long)numWritten;
        } while (allOfIt && this.mBuffer.hasRemaining());
        this.mBuffer.compact();
    }
}

