/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.logging;

import com.ibm.cognos.aurora.core.logging.LogDataHelper;
import com.ibm.cognos.aurora.core.logging.ObjectType;
import com.ibm.cognos.aurora.core.logging.Operation;
import com.ibm.cognos.aurora.core.logging.Status;
import com.ibm.cognos.aurora.core.logging.event.AuditLogEvent;
import com.ibm.cognos.aurora.core.logging.event.TraceLogEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Level;

@Deprecated
public class LogEventHelper {
    public static final String OBJ_SEPARATOR = "::";
    private static final String SPACE = " ";
    private static final String LEFT = "[";
    private static final String RIGHT = "]";

    public static AuditLogEvent createStartServiceEvent(ObjectType objType, Status status) {
        return LogEventHelper.createAuditSystemBasicEvent(objType, status, Operation.STARTSERVICE);
    }

    public static AuditLogEvent createStopServiceEvent(ObjectType objType, Status status) {
        return LogEventHelper.createAuditSystemBasicEvent(objType, status, Operation.STOPSERVICE);
    }

    public static AuditLogEvent createAuditSystemBasicEvent(ObjectType objType, Status status, Operation operation) {
        AuditLogEvent event = new AuditLogEvent();
        event.setObjectType(objType);
        event.setStatus(status);
        event.setOperation(operation);
        return event;
    }

    public static AuditLogEvent createAuditLogEvent4Error(String errorMessage, String tracedObject) {
        return LogEventHelper.createAuditLogEvent4Error(errorMessage, Operation.UNKNOWN, tracedObject);
    }

    public static AuditLogEvent createAuditLogEvent4Error(String errorMessage, Operation operation, String tracedObject) {
        AuditLogEvent event = new AuditLogEvent();
        event.setOperation(operation);
        event.setStatus(Status.FAILURE);
        event.setMessage(errorMessage);
        event.setObjectPath(tracedObject);
        return event;
    }

    public static AuditLogEvent createAuditLogEvent4Error(String errorMessage, Operation operation, String tracedObject, Throwable t) {
        AuditLogEvent event = LogEventHelper.createAuditLogEvent4Error(errorMessage, operation, tracedObject);
        event.setLogData(LogDataHelper.createFreeTextLogData(LogEventHelper.getStackTrace(t)));
        return event;
    }

    public static AuditLogEvent createAuditLogEvent4Error(String errorMessage, String tracedObject, Throwable t) {
        AuditLogEvent event = LogEventHelper.createAuditLogEvent4Error(errorMessage, Operation.UNKNOWN, tracedObject);
        event.setLogData(LogDataHelper.createFreeTextLogData(LogEventHelper.getStackTrace(t)));
        return event;
    }

    private static String getStackTrace(Throwable t) {
        if (t == null) {
            return "";
        }
        StringWriter strWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(strWriter);
        t.printStackTrace(printWriter);
        printWriter.close();
        return strWriter.toString();
    }

    private static String makeLevelPrefix(Level level) {
        if (level != null) {
            return LEFT + level.toString() + RIGHT + SPACE;
        }
        return "";
    }

    public static TraceLogEvent createTraceLogEvent(String message, String tracedObject, Level level) {
        return LogEventHelper.createTraceLogEvent(message, tracedObject, level, true);
    }

    public static TraceLogEvent createTraceLogEvent(String message, String tracedObject, Throwable t, Level level) {
        return LogEventHelper.createTraceLogEvent(message, tracedObject, t, level, true);
    }

    public static TraceLogEvent createTraceLogEvent(AuditLogEvent aEvent, Level level) {
        TraceLogEvent tEvent = new TraceLogEvent();
        if (aEvent != null) {
            tEvent.setSessionID(aEvent.getSessionID());
            tEvent.setRequestID(aEvent.getRequestID());
            tEvent.setSubRequestID(aEvent.getSubRequestID());
            tEvent.setTracedObject(aEvent.getObjectType().getName());
            tEvent.setMessage(LogEventHelper.makeLevelPrefix(level) + aEvent.getTraceMessage() + System.getProperty("line.separator") + aEvent.getLogData().toString());
        }
        return tEvent;
    }

    public static TraceLogEvent createTraceLogEvent(String message, String tracedObject, Level level, boolean isAddLevelPrefix) {
        TraceLogEvent event = new TraceLogEvent();
        if (message == null) {
            message = "";
        }
        if (isAddLevelPrefix) {
            event.setMessage(LogEventHelper.makeLevelPrefix(level) + message);
        } else {
            event.setMessage(message);
        }
        event.setTracedObject(tracedObject);
        return event;
    }

    public static TraceLogEvent createTraceLogEvent(String message, String tracedObject, Throwable t, Level level, boolean isAddLevelPrefix) {
        TraceLogEvent event = new TraceLogEvent();
        if (message == null) {
            message = "";
        }
        StringBuilder sb = new StringBuilder();
        if (isAddLevelPrefix) {
            sb.append(LogEventHelper.makeLevelPrefix(level));
        }
        sb.append(message);
        if (t != null) {
            sb.append(System.getProperty("line.separator"));
        }
        sb.append(LogEventHelper.getStackTrace(t));
        event.setMessage(sb.toString());
        event.setTracedObject(tracedObject);
        return event;
    }
}

