/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.logging.event;

import com.ibm.cognos.aurora.core.logging.ObjectType;
import com.ibm.cognos.aurora.core.logging.Operation;
import com.ibm.cognos.aurora.core.logging.Status;
import com.ibm.cognos.aurora.core.logging.event.AuditLogBaseEvent;
import com.ibm.cognos.aurora.core.logging.event.LogData;
import com.ibm.cognos.aurora.core.logging.event.LogEventType;

public class AuditLogEvent
extends AuditLogBaseEvent {
    private ObjectType objectType;
    private String objectPath = "";
    private Status status;
    private String message = "";

    public AuditLogEvent() {
        this.objectType = ObjectType.UNKNOWN;
        this.status = Status.UNKNOWN;
    }

    public AuditLogEvent(String sessionID, String requestID, String subRequestID, Operation operation, ObjectType objType, String objPath, Status status, String message, LogData logData) {
        super(sessionID, requestID, subRequestID, operation, logData);
        this.objectType = objType == null ? ObjectType.UNKNOWN : objType;
        this.objectPath = objPath == null ? "" : objPath;
        this.status = status == null ? Status.UNKNOWN : status;
        this.message = message == null ? "" : message;
    }

    public void setObjectType(ObjectType objectType) {
        if (objectType != null) {
            this.objectType = objectType;
        }
    }

    public void setObjectPath(String objectPath) {
        if (objectPath != null) {
            this.objectPath = objectPath;
        }
    }

    public void setStatus(Status status) {
        if (status != null) {
            this.status = status;
        }
    }

    public void setMessage(String message) {
        if (message != null) {
            this.message = message;
        }
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AuditLogEvent [").append("sessionID=").append(this.sessionID).append(", ").append("requestID=").append(this.requestID).append(", ").append("subRequestID=").append(this.subRequestID).append(", ").append("operation=").append(this.operation.getName()).append(", ").append("objectType=").append(this.objectType.name()).append(", ").append("objectPath=").append(this.objectPath).append(", ").append("status=").append((Object)this.status).append(", ").append("message=").append(this.message).append(", ").append("logData=").append(this.logData).append(", ").append("]");
        return sb.toString();
    }

    public String getTraceMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("operation=").append(this.operation.getName()).append(", ").append("objectPath=").append(this.objectPath).append(", ").append("status=").append((Object)this.status).append(", ").append("message=").append(this.message).append(", ").append("logData=").append(this.logData).append(", ");
        return sb.toString();
    }

    @Override
    public LogEventType getLogEventType() {
        return LogEventType.AUDITLOGEVENT;
    }
}

