/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.logging.log4j;

import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.ILoggerFactory;
import com.ibm.cognos.aurora.core.logging.LoggingConfiguration;
import com.ibm.cognos.aurora.core.logging.log4j.Log4jLogger;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class Log4jLoggerFactory
implements ILoggerFactory {
    public static final String LOG4JCONFIG = "athena.log4j.config";
    public static final String LOG4J_DEFAULT_CONFIG = "/log4j_athena.xml";

    public Log4jLoggerFactory() throws ClassNotFoundException {
        if (this.isInitializable()) {
            this.initLog4jConfig();
        }
    }

    private void initLog4jConfig() {
        block9: {
            try {
                URL in;
                String log4jConfigFile = null;
                try {
                    Properties props = LoggingConfiguration.getProperties();
                    log4jConfigFile = props.getProperty(LOG4JCONFIG);
                }
                catch (Exception e) {
                    System.out.println(e.getLocalizedMessage() + " Use Athena default log4j config file: " + LOG4J_DEFAULT_CONFIG);
                }
                if (log4jConfigFile == null || log4jConfigFile.isEmpty()) {
                    log4jConfigFile = LOG4J_DEFAULT_CONFIG;
                }
                if ((in = Log4jLoggerFactory.class.getResource(log4jConfigFile)) == null) {
                    in = ClassLoader.getSystemResource(log4jConfigFile);
                }
                if (in != null) {
                    try {
                        DOMConfigurator.configure((URL)in);
                        break block9;
                    }
                    catch (FactoryConfigurationError ex) {
                        System.out.println(Log4jLoggerFactory.class.getName() + "::initLog4jConfig()   Unabled to parse %s!" + in.getFile());
                        throw ex;
                    }
                }
                throw new IOException(String.format("Log4j configuration file %s is missing. Unable to initialize log4j!", log4jConfigFile));
            }
            catch (IOException e) {
                System.out.println(Log4jLoggerFactory.class.getName() + "::initLog4jConfig()\tUnabled to initialze log4j!");
                System.out.println(e.getLocalizedMessage());
                this.setDefaultRootCategories();
                System.out.println("Set Root Category logging level OFF!");
            }
        }
    }

    private void setDefaultRootCategories() {
        Logger traceRootLogger = Logger.getLogger((String)"Trace");
        this.setLevelOffIfNull(traceRootLogger);
        Logger auditRootLogger = Logger.getLogger((String)"Audit.RTUsage");
        this.setLevelOffIfNull(auditRootLogger);
        Logger perfRootLogger = Logger.getLogger((String)"Perf");
        this.setLevelOffIfNull(perfRootLogger);
    }

    private void setLevelOffIfNull(Logger logger) {
        if (logger.getLevel() == null) {
            logger.setLevel(Level.OFF);
        }
    }

    @Override
    public ILogger makeNewLoggerInstance(String categoryName) {
        Log4jLogger log4jLogger = new Log4jLogger();
        Logger traceLogger = Logger.getLogger((String)("Trace." + categoryName));
        log4jLogger.setTraceLogger(traceLogger);
        Logger auditLogger = Logger.getLogger((String)("Audit.RTUsage." + categoryName));
        log4jLogger.setAuditLogger(auditLogger);
        Logger perfLogger = Logger.getLogger((String)("Perf." + categoryName));
        log4jLogger.setPerfLogger(perfLogger);
        return log4jLogger;
    }

    @Override
    public boolean isInitializable() throws ClassNotFoundException {
        try {
            Class.forName(Logger.class.getName());
            return true;
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex.getLocalizedMessage() + " Log4j Logger is not initializable. ");
            throw ex;
        }
    }
}

