/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.logging.log4j;

import java.util.concurrent.TimeUnit;

class ResourceCounterSet {
    protected boolean rcs_isActive = true;
    protected String resourceID = null;
    protected ResourceCounterSet parent = null;
    protected int depth = 0;
    protected long m_elapsedTime = 0L;
    protected long m_startTime = 0L;

    public ResourceCounterSet() {
        this.parent = null;
    }

    public ResourceCounterSet(String resourceID, ResourceCounterSet parent) {
        this.resourceID = resourceID;
        this.parent = parent;
        if (parent != null) {
            this.depth = parent.getDepth() + 1;
        }
    }

    public synchronized void reset() {
        this.m_elapsedTime = 0L;
        this.m_startTime = 0L;
    }

    public synchronized void enableResourceCounter() {
        this.rcs_isActive = true;
        this.startElapsedTimer();
    }

    public synchronized void disableResourceCounter() {
        this.rcs_isActive = false;
        this.stopElapsedTimer();
    }

    private void startElapsedTimer() {
        this.m_startTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    private void stopElapsedTimer() {
        this.m_elapsedTime += TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - this.m_startTime;
    }

    public long getElapsedTime() {
        return this.m_elapsedTime;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public int getDepth() {
        return this.depth;
    }

    public String resourceToString() {
        return Long.toString(this.m_elapsedTime);
    }
}

