/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.messages;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundleControl
extends ResourceBundle.Control {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleControl.class);
    private String encoding;

    public ResourceBundleControl() {
        this("UTF-8");
    }

    public ResourceBundleControl(String encoding) {
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        String bundleName = this.toBundleName(baseName, locale);
        ResourceBundle bundle = null;
        if ("java.class".equals(format)) {
            try {
                Class<?> bundleClass = loader.loadClass(bundleName);
                if (!ResourceBundle.class.isAssignableFrom(bundleClass)) {
                    throw new ClassCastException(bundleClass.getName() + " cannot be cast to ResourceBundle");
                }
                bundle = (ResourceBundle)bundleClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug(e.getLocalizedMessage());
            }
        } else {
            if ("java.properties".equals(format)) {
                final String resourceName = this.toResourceName(bundleName, "properties");
                final ClassLoader classLoader = loader;
                final boolean reloadFlag = reload;
                InputStream stream = null;
                try {
                    stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws IOException {
                            InputStream is = null;
                            if (reloadFlag) {
                                URLConnection connection;
                                URL url = classLoader.getResource(resourceName);
                                if (url != null && (connection = url.openConnection()) != null) {
                                    connection.setUseCaches(false);
                                    is = connection.getInputStream();
                                }
                            } else {
                                is = classLoader.getResourceAsStream(resourceName);
                            }
                            return is;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getException();
                }
                InputStreamReader isr = null;
                try {
                    isr = new InputStreamReader(stream, this.encoding);
                    bundle = new PropertyResourceBundle(isr);
                }
                finally {
                    if (isr != null) {
                        isr.close();
                    }
                    stream.close();
                }
            }
            throw new IllegalArgumentException("Unknown bundle format: " + format);
        }
        return bundle;
    }
}

