/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model;

import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class DataItemStats
implements IDataItemStats {
    private long mCount;
    private long mDistinctCount;
    private long mNullCount;
    private IValue mMinValue;
    private IValue mMaxValue;
    private boolean mNullable = false;
    private float mDensity = 1.0f;

    @Override
    public long count() {
        return this.mCount;
    }

    public void setCount(long count) {
        this.mCount = count;
    }

    @Override
    public long distinctCount() {
        return this.mDistinctCount;
    }

    public void setDistinctCount(long distinctCount) {
        this.mDistinctCount = distinctCount;
    }

    @Override
    public long nullCount() {
        return this.mNullCount;
    }

    public void setNullCount(long nullCount) {
        this.mNullCount = nullCount;
    }

    @Override
    public long totalCount() {
        return this.mCount + this.mNullCount;
    }

    @Override
    public IValue minValue() {
        return this.mMinValue;
    }

    public void setMinValue(IValue minValue) {
        this.mMinValue = minValue;
    }

    @Override
    public IValue maxValue() {
        return this.mMaxValue;
    }

    public void setMaxValue(IValue maxValue) {
        this.mMaxValue = maxValue;
    }

    @Override
    public boolean isNullable() {
        return this.mNullable;
    }

    public void setNullable(boolean isNullable) {
        this.mNullable = isNullable;
    }

    @Override
    public float density() {
        return this.mDensity;
    }

    public void setDensity(float density) {
        this.mDensity = density;
    }

    @Override
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        out.writeLong(this.mCount);
        out.writeFloat(this.mDensity);
        out.writeLong(this.mDistinctCount);
        out.writeBoolean(this.mNullable);
        out.writeLong(this.mNullCount);
        if (null != this.mMaxValue) {
            out.writeBoolean(true);
            ValueFactory.encodeBinary(out, ctx, this.mMaxValue);
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mMinValue) {
            out.writeBoolean(true);
            ValueFactory.encodeBinary(out, ctx, this.mMinValue);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        this.mCount = in.readLong();
        this.mDensity = in.readFloat();
        this.mDistinctCount = in.readLong();
        this.mNullable = in.readBoolean();
        this.mNullCount = in.readLong();
        this.mMaxValue = in.readBoolean() ? ValueFactory.decodeBinary(in, ctx) : null;
        this.mMinValue = in.readBoolean() ? ValueFactory.decodeBinary(in, ctx) : null;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        return builder.append("count", this.count()).append("nullCount", this.nullCount()).append("totalCount", this.totalCount()).append("distinctCount", this.distinctCount()).append("density", this.density()).append("nullable", this.isNullable()).append("minValue", (Object)this.minValue()).append("maxValue", (Object)this.maxValue()).toString();
    }
}

