/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model.ICUformat;

import com.ibm.cognos.aurora.core.model.ICUformat.FormatPropertyEnum;
import com.ibm.cognos.aurora.core.model.ICUformat.IsValidPropertyUtilities;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatProperties {
    private Map<FormatPropertyEnum, Object> properties;
    private boolean defaultPercentage = false;
    private static final transient Logger LOG = LoggerFactory.getLogger(FormatProperties.class);

    public FormatProperties() {
        this.properties = new TreeMap<FormatPropertyEnum, Object>();
    }

    public FormatProperties(FormatProperties sourceProperties) {
        this.properties = new TreeMap<FormatPropertyEnum, Object>(sourceProperties.properties);
    }

    public void addProperty(FormatPropertyEnum pName, Object pValue) {
        if (this.isValidValue(pName, pValue)) {
            this.properties.put(pName, pValue);
        } else {
            LOG.error("Invalid FormatProprty-Value pair");
        }
    }

    public boolean isDefaultPercentage() {
        return this.defaultPercentage;
    }

    public void setDefaultPercentage(boolean value) {
        this.defaultPercentage = value;
    }

    public Object getValue(FormatPropertyEnum pName) {
        return this.properties.get((Object)pName);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FormatProperties)) {
            return false;
        }
        FormatProperties other = (FormatProperties)o;
        return this.properties.entrySet().equals(other.properties.entrySet());
    }

    public int hashCode() {
        return this.properties.entrySet().hashCode();
    }

    private boolean isValidValue(FormatPropertyEnum pName, Object pValue) {
        if (pValue == null) {
            return true;
        }
        return IsValidPropertyUtilities.valid(pName, pValue);
    }
}

