/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model.ICUformat;

import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.datatype.TimeType;
import com.ibm.cognos.aurora.api.model.datatype.TimestampType;
import com.ibm.cognos.aurora.api.model.value.BooleanValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.IntegerValue;
import com.ibm.cognos.aurora.api.model.value.StringValue;
import com.ibm.cognos.aurora.api.model.value.ValueBase;
import com.ibm.cognos.aurora.core.model.ICUformat.CurrencyDisplay;
import com.ibm.cognos.aurora.core.model.ICUformat.DateTime;
import com.ibm.cognos.aurora.core.model.ICUformat.FormatProperties;
import com.ibm.cognos.aurora.core.model.ICUformat.FormatPropertyEnum;
import com.ibm.cognos.aurora.core.model.ICUformat.TreatAs;
import com.ibm.json.java.JSONObject;
import java.io.IOException;

public class FormatPropertiesUtil {
    public static final int getDecimalSize(IAttribute attribute) {
        Object decimalSizeObj;
        IDataItem dataItem;
        FormatProperties formatProperties;
        int decimalSize = -1;
        INode node = attribute.getNode();
        if (node != null && (formatProperties = (dataItem = node.getDataItem()).getFormatProperties()) != null && (decimalSizeObj = formatProperties.getValue(FormatPropertyEnum.DECIMAL_PLACES)) != null) {
            try {
                decimalSize = Integer.valueOf(decimalSizeObj.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return decimalSize;
    }

    public static com.ibm.cognos.aurora.core.model.format.FormatProperties formatPropertiesFromJSON(String jsonString) {
        com.ibm.cognos.aurora.core.model.format.FormatProperties format = new com.ibm.cognos.aurora.core.model.format.FormatProperties();
        JSONObject formatJson = null;
        try {
            formatJson = JSONObject.parse((String)jsonString);
        }
        catch (IOException e) {
            return format;
        }
        if (formatJson.containsKey((Object)"type")) {
            String type = (String)formatJson.get((Object)"type");
            format.setFormatType(Integer.parseInt(type));
        }
        for (com.ibm.cognos.aurora.core.model.format.FormatPropertyEnum e : com.ibm.cognos.aurora.core.model.format.FormatPropertyEnum.values()) {
            if (!formatJson.containsKey((Object)e.toString())) continue;
            String jsonBlobStr = (String)formatJson.get((Object)e.toString());
            JSONObject jsonValue = null;
            try {
                jsonValue = JSONObject.parse((String)jsonBlobStr);
            }
            catch (IOException e1) {
                return format;
            }
            String classStr = (String)jsonValue.get((Object)"class");
            ValueBase val = null;
            if (classStr.equals("StringValue")) {
                val = new StringValue();
            } else if (classStr.equals("BooleanValue")) {
                val = new BooleanValue();
            }
            if (val == null) continue;
            val.assignFrom((String)jsonValue.get((Object)"value"));
            format.addProperty(e, val);
        }
        return format;
    }

    public static FormatProperties icuFormatPropertiesFromJSON(String jsonString) {
        FormatProperties format = new FormatProperties();
        JSONObject formatJson = null;
        try {
            formatJson = JSONObject.parse((String)jsonString);
        }
        catch (IOException e) {
            return format;
        }
        for (FormatPropertyEnum e : FormatPropertyEnum.values()) {
            if (!formatJson.containsKey((Object)e.toString())) continue;
            String jsonBlobStr = (String)formatJson.get((Object)e.toString());
            JSONObject jsonValue = null;
            try {
                jsonValue = JSONObject.parse((String)jsonBlobStr);
            }
            catch (IOException e1) {
                return format;
            }
            String classStr = (String)jsonValue.get((Object)"class");
            Object val = null;
            if (classStr.endsWith("StringValue")) {
                val = new StringValue();
                ((IValue)val).assignFrom((String)jsonValue.get((Object)"value"));
            } else if (classStr.endsWith("BooleanValue")) {
                val = new BooleanValue();
                ((IValue)val).assignFrom((String)jsonValue.get((Object)"value"));
            } else if (classStr.endsWith("CurrencyDisplay")) {
                val = CurrencyDisplay.valueOf((String)jsonValue.get((Object)"value"));
            } else if (classStr.endsWith("DateTime")) {
                val = DateTime.valueOf((String)jsonValue.get((Object)"value"));
            } else {
                System.out.println("Need to add icuFormatPropertiesFromJSON for class " + classStr);
            }
            if (val == null) continue;
            format.addProperty(e, val);
        }
        return format;
    }

    public static JSONObject icuFormatPropertiesToJSON(FormatProperties icu) {
        JSONObject formatJson = new JSONObject();
        for (FormatPropertyEnum e : FormatPropertyEnum.values()) {
            if (icu.getValue(e) == null) continue;
            String key = e.toString();
            Object obj = icu.getValue(e);
            JSONObject objectValue = new JSONObject();
            if (obj instanceof StringValue) {
                StringValue value = (StringValue)obj;
                objectValue.put((Object)"value", (Object)value.stringValue());
            } else {
                objectValue.put((Object)"value", (Object)obj.toString());
                objectValue.put((Object)"class", (Object)obj.getClass().toString());
            }
            formatJson.put((Object)key, (Object)objectValue);
        }
        return formatJson;
    }

    public static JSONObject formatPropertiesToJSON(com.ibm.cognos.aurora.core.model.format.FormatProperties format) {
        JSONObject formatJson = new JSONObject();
        for (com.ibm.cognos.aurora.core.model.format.FormatPropertyEnum e : com.ibm.cognos.aurora.core.model.format.FormatPropertyEnum.values()) {
            if (format.getValue(e) == null) continue;
            String key = e.toString();
            Object obj = format.getValue(e);
            JSONObject objectValue = new JSONObject();
            if (obj instanceof StringValue) {
                StringValue value = (StringValue)obj;
                formatJson.put((Object)key, (Object)value.stringValue());
                continue;
            }
            if (obj instanceof String) {
                String str = (String)obj;
                formatJson.put((Object)key, (Object)str);
                continue;
            }
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                formatJson.put((Object)key, (Object)b);
                continue;
            }
            if (obj instanceof Integer) {
                Integer i = (Integer)obj;
                formatJson.put((Object)key, (Object)i);
                continue;
            }
            objectValue.put((Object)"value", (Object)obj.toString());
            objectValue.put((Object)"class", (Object)obj.getClass().toString());
            formatJson.put((Object)key, (Object)objectValue);
        }
        if (format.isCurrencyType()) {
            formatJson.put((Object)"type", (Object)"CURRENCY_TYPE");
        } else if (format.isPercentType()) {
            formatJson.put((Object)"type", (Object)"PERCENT_TYPE");
        } else if (format.isNumberType()) {
            formatJson.put((Object)"type", (Object)"NUMBER_TYPE");
        } else if (format.isDateTimeType()) {
            formatJson.put((Object)"type", (Object)"DATETIME_TYPE");
        }
        return formatJson;
    }

    public static FormatProperties getDataTypeFormatProperties(IDataType dataType) {
        FormatProperties formatProperties = new FormatProperties();
        formatProperties.addProperty(FormatPropertyEnum.SHOW_NULL_AS, new StringValue(" "));
        if (dataType.isNumeric()) {
            formatProperties.addProperty(FormatPropertyEnum.USE_GROUPING, new BooleanValue(!dataType.isInteger()));
            if (!dataType.isInteger()) {
                formatProperties.addProperty(FormatPropertyEnum.DECIMAL_PLACES, new IntegerValue(2));
            }
        }
        if (dataType.getBaseType().equals((Object)BaseDataType.DATE) || dataType.getBaseType().equals((Object)BaseDataType.TIMESTAMP)) {
            formatProperties.addProperty(FormatPropertyEnum.YEAR, (Object)DateTime.NUMERIC);
            formatProperties.addProperty(FormatPropertyEnum.MONTH, (Object)DateTime.TWO_DIGIT);
            formatProperties.addProperty(FormatPropertyEnum.WEEKDAY, (Object)DateTime.NONE);
            formatProperties.addProperty(FormatPropertyEnum.DAY, (Object)DateTime.TWO_DIGIT);
        }
        if (dataType.getBaseType().equals((Object)BaseDataType.TIME) || dataType.getBaseType().equals((Object)BaseDataType.TIMESTAMP)) {
            formatProperties.addProperty(FormatPropertyEnum.HOUR, (Object)DateTime.TWO_DIGIT);
            formatProperties.addProperty(FormatPropertyEnum.MINUTE, (Object)DateTime.TWO_DIGIT);
            formatProperties.addProperty(FormatPropertyEnum.SECOND, (Object)DateTime.TWO_DIGIT);
            formatProperties.addProperty(FormatPropertyEnum.HOUR_FORMAT, new BooleanValue(false));
        }
        return formatProperties;
    }

    public static TreatAs getDataTypeTreatAs(IDataType dataType) {
        TreatAs treatAs = TreatAs.TEXT;
        if (dataType.isNumeric()) {
            treatAs = TreatAs.NUMERIC;
        } else if (dataType.isTemporal()) {
            treatAs = TimestampType.class.isInstance(dataType) ? TreatAs.TIMESTAMP : (TimeType.class.isInstance(dataType) ? TreatAs.TIME : TreatAs.DATE);
        }
        return treatAs;
    }
}

