/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model.ICUformat;

import com.ibm.cognos.aurora.api.model.value.BooleanValue;
import com.ibm.cognos.aurora.api.model.value.IntegerValue;
import com.ibm.cognos.aurora.api.model.value.StringValue;
import com.ibm.cognos.aurora.core.model.ICUformat.CurrencyDisplay;
import com.ibm.cognos.aurora.core.model.ICUformat.DateTime;
import com.ibm.cognos.aurora.core.model.ICUformat.DurationUnits;
import com.ibm.cognos.aurora.core.model.ICUformat.FormatPropertyEnum;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IsValidPropertyUtilities {
    private static final transient Logger LOG = LoggerFactory.getLogger(IsValidPropertyUtilities.class);

    private IsValidPropertyUtilities() {
    }

    public static boolean valid(FormatPropertyEnum pName, Object pValue) {
        boolean valid = false;
        switch (pName) {
            case SHOW_NULL_AS: {
                if (!(pValue instanceof StringValue)) break;
                valid = true;
                break;
            }
            case SHOW_ZERO_AS: {
                if (!(pValue instanceof StringValue)) break;
                valid = true;
                break;
            }
            case MAXIMUM_CHARACTERS: {
                if (pValue == null) {
                    valid = true;
                    break;
                }
                if (pValue instanceof IntegerValue) {
                    if (((IntegerValue)pValue).intValue() < 1) break;
                    valid = true;
                    break;
                }
                LOG.error("maximumCharacters should be an integer greater than or equal to 1");
                break;
            }
            case TRUNCATION_STRING: {
                if (pValue == null) {
                    valid = true;
                    break;
                }
                if (!(pValue instanceof StringValue)) break;
                valid = true;
                break;
            }
            case HOUR_FORMAT: {
                if (pValue instanceof BooleanValue) {
                    valid = true;
                    break;
                }
                LOG.error("hour12 should be a boolean value");
                break;
            }
            case USE_GROUPING: {
                if (pValue instanceof BooleanValue) {
                    valid = true;
                    break;
                }
                LOG.error("useGrouping should be a boolean value");
                break;
            }
            case DECIMAL_PLACES: {
                if (pValue == null) {
                    valid = true;
                    break;
                }
                if (pValue instanceof IntegerValue) {
                    if (((IntegerValue)pValue).intValue() < 0) break;
                    valid = true;
                    break;
                }
                LOG.error("decimalPlaces should be an integer greater than or equal to 0");
                break;
            }
            case CURRENCY_CODE: {
                if (!(pValue instanceof StringValue)) break;
                valid = true;
                break;
            }
            case CURRENCY_DISPLAY: {
                valid = pValue instanceof CurrencyDisplay;
                break;
            }
            case DURATION_UNITS: {
                if (!(pValue instanceof List)) break;
                boolean isListOfDuraitonUnits = true;
                for (Object o : (List)pValue) {
                    if (o instanceof DurationUnits) continue;
                    isListOfDuraitonUnits = false;
                }
                if (!isListOfDuraitonUnits) break;
                valid = true;
                break;
            }
            case YEAR: {
                if (pValue != DateTime.NUMERIC && pValue != DateTime.TWO_DIGIT && pValue != DateTime.NONE) break;
                valid = true;
                break;
            }
            case MONTH: {
                if (!(pValue instanceof DateTime)) break;
                valid = true;
                break;
            }
            case WEEKDAY: {
                if (pValue != DateTime.NARROW && pValue != DateTime.SHORT && pValue != DateTime.LONG && pValue != DateTime.NONE) break;
                valid = true;
                break;
            }
            case DAY: {
                if (pValue != DateTime.NUMERIC && pValue != DateTime.TWO_DIGIT && pValue != DateTime.NONE) break;
                valid = true;
                break;
            }
            case HOUR: {
                if (pValue != DateTime.NUMERIC && pValue != DateTime.TWO_DIGIT && pValue != DateTime.NONE) break;
                valid = true;
                break;
            }
            case MINUTE: {
                if (pValue != DateTime.NUMERIC && pValue != DateTime.TWO_DIGIT && pValue != DateTime.NONE) break;
                valid = true;
                break;
            }
            case SECOND: {
                if (pValue != DateTime.NUMERIC && pValue != DateTime.TWO_DIGIT && pValue != DateTime.NONE) break;
                valid = true;
                break;
            }
            case DURATION_DESCRIPTOR: {
                if (pValue != DateTime.LONG && pValue != DateTime.SHORT) break;
                valid = true;
                break;
            }
        }
        return valid;
    }
}

