/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.model.ISampleData;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.aurora.api.query.data.IValueTupleIterator;
import com.ibm.cognos.aurora.core.model.DataItemStats;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.NullArgumentException;

public final class InMemorySampleData
implements ISampleData {
    private final IDataItem[] mDataItems;
    private final DataItemStats[] mSampleStats;
    private final ArrayList<IValue[]> mSampleTuples = new ArrayList();
    private final TreeSet<IValue>[] mDistinctValues;

    public InMemorySampleData(IDataItem[] dataItems) {
        if (null == dataItems) {
            throw new NullArgumentException("dataItems");
        }
        this.mDataItems = dataItems;
        this.mSampleStats = new DataItemStats[dataItems.length];
        this.mDistinctValues = new TreeSet[dataItems.length];
        for (int i = 0; i < dataItems.length; ++i) {
            this.mSampleStats[i] = new DataItemStats();
            this.mDistinctValues[i] = new TreeSet();
        }
    }

    @Override
    public int numDataItems() {
        return this.mDataItems.length;
    }

    @Override
    public IDataItem getDataItem(int dataItemIndex) {
        return this.mDataItems[dataItemIndex];
    }

    @Override
    public int indexOfDataItem(IDataItem dataItem) {
        for (int i = 0; i < this.mDataItems.length; ++i) {
            if (!dataItem.getId().equals(this.mDataItems[i].getId())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public long numSamples() {
        return this.mSampleTuples.size();
    }

    @Override
    public IDataItemStats getSampleStats(int dataItemIndex) {
        return this.mSampleStats[dataItemIndex];
    }

    @Override
    public IValueTupleIterator tupleIterator() {
        return new TupleIter();
    }

    @Override
    public IValueIterator valueIterator(int dataItemIndex) {
        return new ValueIter(dataItemIndex);
    }

    @Override
    public Set<IValue> distinctValues(int dataItemIndex) {
        return Collections.unmodifiableSet(this.mDistinctValues[dataItemIndex]);
    }

    public void addSampleTuple(IValue[] tuple) {
        if (tuple.length != this.numDataItems()) {
            throw new IllegalArgumentException("tuple length is inconsistent with number of data items");
        }
        this.mSampleTuples.add(tuple);
        for (int i = 0; i < tuple.length; ++i) {
            IValue v = tuple[i];
            DataItemStats stats = this.mSampleStats[i];
            if (v == null || v.isNull()) {
                stats.setNullable(true);
                stats.setNullCount(stats.nullCount() + 1L);
            } else {
                stats.setCount(stats.count() + 1L);
                if (this.mDistinctValues[i].add(v)) {
                    stats.setDistinctCount(this.mDistinctValues[i].size());
                    if (null == stats.minValue() || v.compareTo(stats.minValue()) < 0) {
                        stats.setMinValue(v);
                    }
                    if (null == stats.maxValue() || v.compareTo(stats.maxValue()) > 0) {
                        stats.setMaxValue(v);
                    }
                }
            }
            stats.setDensity(1.0f - (float)stats.nullCount() / (float)stats.totalCount());
        }
    }

    public void addDistinctValue(int idxItem, IValue value) {
        if (idxItem < this.mDistinctValues.length) {
            this.mDistinctValues[idxItem].add(value);
        }
    }

    private final class ValueIter
    implements IValueIterator {
        private final int mDataItemIndex;
        private Iterator<IValue[]> mSource;

        public ValueIter(int dataItemIndex) {
            this.mSource = InMemorySampleData.this.mSampleTuples.iterator();
            this.mDataItemIndex = dataItemIndex;
        }

        @Override
        public boolean hasNext() {
            return this.mSource.hasNext();
        }

        @Override
        public IValue next() {
            return this.mSource.next()[this.mDataItemIndex];
        }

        @Override
        public void reset() {
            this.mSource = InMemorySampleData.this.mSampleTuples.iterator();
        }

        @Override
        public void close() {
        }
    }

    private final class TupleIter
    implements IValueTupleIterator {
        private Iterator<IValue[]> mSource;

        private TupleIter() {
            this.mSource = InMemorySampleData.this.mSampleTuples.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.mSource.hasNext();
        }

        @Override
        public IValue[] next() {
            return this.mSource.next();
        }

        @Override
        public void reset() {
            this.mSource = InMemorySampleData.this.mSampleTuples.iterator();
        }

        @Override
        public void close() {
        }
    }
}

