/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.core.model.NodeFilters;
import java.util.ArrayList;
import java.util.List;

public final class MetricCategoryScopeHelper {
    public static final String CATEGORIES_IN_SCOPE = "leafCategoriesInScope";
    private List<INode> mLeafCatNodes = new ArrayList<INode>();

    public MetricCategoryScopeHelper(IAssociativeModel aModel) {
        this.collectLeafCategoryNodes(aModel);
    }

    public List<INode> getLowestCategoriesInScope(INode aMetricNode) {
        List levelsInScope = (List)aMetricNode.getProperty(CATEGORIES_IN_SCOPE);
        if (levelsInScope == null) {
            return this.mLeafCatNodes;
        }
        return levelsInScope;
    }

    private void collectLeafCategoryNodes(IAssociativeModel aModel) {
        for (INode aNode : aModel.findNodes(NodeFilters.isCategory())) {
            if (!this.isLeafCatagoryNode(aNode)) continue;
            this.mLeafCatNodes.add(aNode);
        }
    }

    private boolean isLeafCatagoryNode(INode aNode) {
        Iterable<IEdge> outEdges = aNode.getOutEdges(new String[0]);
        boolean hasPart = false;
        for (IEdge edge : outEdges) {
            if (!edge.isWholePart()) continue;
            hasPart = true;
        }
        return !hasPart;
    }
}

