/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model;

import com.ibm.cognos.aurora.api.model.EAggregateType;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.IJoinAttribute;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.IQueryModel;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.StringValue;
import com.ibm.cognos.aurora.api.model.value.ValueStatus;
import com.ibm.cognos.aurora.api.smd.kb.IBinningRange;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.model.NodeFilters;
import com.ibm.cognos.aurora.core.util.StringSubstitutionEngine;
import com.ibm.cognos.aurora.core.util.UniqueNameParser;
import com.ibm.cognos.aurora.core.util.UniqueNameParserException;
import com.ibm.cognos.aurora.core.util.collection.FilteringIterable;
import com.ibm.cognos.aurora.core.util.collection.IFilter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class NavigationHelper {
    private static final List<String> gSpecialConcepts = new ArrayList<String>(1);
    private final IDataContainer mContainer;
    private List<INode> rootCategories = null;
    private INode mDefaultMetric = null;

    public NavigationHelper(IAssociativeModel m) {
        this.mContainer = m.getRootContainer();
    }

    public List<INode> getRootNodes() {
        ArrayList<INode> outNodes = new ArrayList<INode>(20);
        this.collectRootNodes(this.mContainer, outNodes, null);
        return outNodes;
    }

    public List<INode> getRootNodesFiltered(List<String> excludeConcepts) {
        ArrayList<INode> outNodes = new ArrayList<INode>(20);
        this.collectRootNodes(this.mContainer, outNodes, excludeConcepts);
        return outNodes;
    }

    private void collectRootNodes(IDataContainer dc, List<INode> allNodes, List<String> excludeConcepts) {
        List<INode> nodes = dc.getNodes();
        for (INode aNode : nodes) {
            if (!NavigationHelper.isRootNode(aNode) || NavigationHelper.isFiltered(aNode, excludeConcepts)) continue;
            allNodes.add(aNode);
        }
        if (dc.getChildren() != null) {
            for (IDataContainer c : dc.getChildren()) {
                this.collectRootNodes(c, allNodes, excludeConcepts);
            }
        }
    }

    public List<INode> getCategoryNodesFiltered(List<String> excludeConcepts) {
        ArrayList<INode> outNodes = new ArrayList<INode>(20);
        this.collectNodesByClass(this.mContainer, IConcept.EConceptClass.category, outNodes, excludeConcepts);
        return outNodes;
    }

    public List<INode> getAttributeNodesFiltered(List<String> excludeConcepts) {
        ArrayList<INode> outNodes = new ArrayList<INode>(20);
        this.collectNodesByClass(this.mContainer, IConcept.EConceptClass.attribute, outNodes, excludeConcepts);
        return outNodes;
    }

    public List<INode> getMetricNodesFiltered(List<String> excludeConcepts) {
        ArrayList<INode> outNodes = new ArrayList<INode>(20);
        this.collectNodesByClass(this.mContainer, IConcept.EConceptClass.metric, outNodes, excludeConcepts);
        return outNodes;
    }

    public List<INode> getCategoryAndMetricNodesFiltered(List<String> excludeConcepts) {
        ArrayList<INode> outNodes = new ArrayList<INode>(30);
        this.collectNodesByClass(this.mContainer, IConcept.EConceptClass.category, outNodes, excludeConcepts);
        this.collectNodesByClass(this.mContainer, IConcept.EConceptClass.metric, outNodes, excludeConcepts);
        return outNodes;
    }

    public List<INode> getAttributeAndMetricNodesFiltered(List<String> excludeConcepts) {
        ArrayList<INode> outNodes = new ArrayList<INode>(30);
        this.collectNodesByClass(this.mContainer, IConcept.EConceptClass.attribute, outNodes, excludeConcepts);
        this.collectNodesByClass(this.mContainer, IConcept.EConceptClass.metric, outNodes, excludeConcepts);
        return outNodes;
    }

    private void collectNodesByClass(IDataContainer dc, IConcept.EConceptClass eClass, List<INode> allNodes, List<String> excludeConcepts) {
        List<INode> nodes = dc.getNodes();
        for (INode aNode : nodes) {
            if (!aNode.getConcept().supportsClassification(eClass) || allNodes.contains(aNode) || NavigationHelper.isFiltered(aNode, excludeConcepts)) continue;
            allNodes.add(aNode);
        }
        if (dc.getChildren() != null) {
            for (IDataContainer c : dc.getChildren()) {
                this.collectNodesByClass(c, eClass, allNodes, excludeConcepts);
            }
        }
    }

    private static boolean isFiltered(INode aNode, List<String> excludeConcepts) {
        return excludeConcepts != null && excludeConcepts.contains(aNode.getConcept().getName());
    }

    public static boolean isRootNode(INode aNode) {
        return aNode.getDataItem() == null || aNode.isMetric();
    }

    public static List<String> getSpeciallyTreatedConcepts() {
        return gSpecialConcepts;
    }

    public List<INode> getDataItemNodes() {
        ArrayList<INode> outNodes = new ArrayList<INode>(20);
        this.collectDataItemNodes(this.mContainer, outNodes);
        return outNodes;
    }

    private void collectDataItemNodes(IDataContainer dc, List<INode> allNodes) {
        List<INode> nodes = dc.getNodes();
        for (INode aNode : nodes) {
            if (aNode.getDataItem() == null) continue;
            allNodes.add(aNode);
        }
        if (dc.getChildren() != null) {
            for (IDataContainer c : dc.getChildren()) {
                this.collectDataItemNodes(c, allNodes);
            }
        }
    }

    public static List<INode> getAttributeNodes(INode aNode) {
        if (!aNode.isCategory()) {
            return null;
        }
        ArrayList<INode> outNodes = new ArrayList<INode>(3);
        Iterable<IEdge> edges = aNode.getOutEdges(new String[0]);
        for (IEdge e : edges) {
            INode nodeTo;
            if (e.isWholePart() || !(nodeTo = e.getEnd()).isAttribute()) continue;
            outNodes.add(nodeTo);
        }
        return outNodes;
    }

    public static INode getCategoryFromAttribute(INode attribute) {
        if (attribute == null || !attribute.isAttribute()) {
            return null;
        }
        Iterable<IEdge> edges = attribute.getInEdges(new String[0]);
        if (edges.iterator().hasNext()) {
            IEdge edge = edges.iterator().next();
            return edge.getStart();
        }
        return null;
    }

    public static INode getDefaultAttributeNode(INode aNode) {
        if (!aNode.isCategory()) {
            if (aNode.isAttribute()) {
                return aNode;
            }
            return null;
        }
        INode nodeIdentifier = null;
        INode nodeOther = null;
        Iterable<IEdge> edges = aNode.getOutEdges(new String[0]);
        for (IEdge e : edges) {
            INode nodeTo;
            if (e.isWholePart() || !(nodeTo = e.getEnd()).isAttribute()) continue;
            if ("cCaption".equals(nodeTo.getConcept().getName())) {
                return nodeTo;
            }
            if ("cIdentifier".equals(nodeTo.getConcept().getName())) {
                nodeIdentifier = nodeTo;
                continue;
            }
            nodeOther = nodeTo;
        }
        return nodeIdentifier != null ? nodeIdentifier : nodeOther;
    }

    public static INode getIdentifierAttributeFromCategory(INode aNode) {
        if (aNode.isCategory()) {
            Iterable<IEdge> edges = aNode.getOutEdges(new String[0]);
            for (IEdge e : edges) {
                INode nodeTo;
                if (e.isWholePart() || !(nodeTo = e.getEnd()).isAttribute() || !"cIdentifier".equals(nodeTo.getConcept().getName())) continue;
                return nodeTo;
            }
        }
        return NavigationHelper.getDefaultAttributeNode(aNode);
    }

    public static List<INode> getPartNodes(INode aNode) {
        ArrayList<INode> partNodes = new ArrayList<INode>(3);
        NavigationHelper.collectPartNodes(aNode, partNodes, false);
        return partNodes;
    }

    public static List<INode> getIsPartOfNodes(INode aNode) {
        ArrayList<INode> partNodes = new ArrayList<INode>(3);
        NavigationHelper.collectPartNodes(aNode, partNodes, true);
        return partNodes;
    }

    private static List<INode> collectPartNodes(INode aNode, List<INode> partNodes, boolean bInEdges) {
        Iterable<IEdge> edges = bInEdges ? aNode.getInEdges(new String[0]) : aNode.getOutEdges(new String[0]);
        for (IEdge e : edges) {
            INode nodeFrom;
            if (!e.isWholePart()) continue;
            INode iNode = nodeFrom = bInEdges ? e.getStart() : e.getEnd();
            if (partNodes.contains(nodeFrom)) {
                StringBuilder sb = new StringBuilder("Circular whole-part relationship detected: ");
                for (INode node : partNodes) {
                    if (node.getConcept() == null) continue;
                    sb.append(node.getConcept().getName());
                    sb.append(" ,");
                }
                throw new RuntimeException(sb.toString());
            }
            partNodes.add(nodeFrom);
            NavigationHelper.collectPartNodes(nodeFrom, partNodes, bInEdges);
            break;
        }
        return partNodes;
    }

    public static List<INode> getHierarchy(INode node) {
        List<INode> nodes;
        List<INode> hierarchy = NavigationHelper.getPartNodes(node);
        hierarchy.add(0, node);
        INode tmpNode = node;
        while ((nodes = NavigationHelper.getIsPartOfNodes(tmpNode)).size() != 0) {
            tmpNode = nodes.get(0);
            hierarchy.add(0, tmpNode);
        }
        return hierarchy;
    }

    public void modelAsXML(OutputStreamWriter osw) {
        try {
            osw.write(NavigationHelper.dataContainerToXML(this.mContainer));
            osw.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static String dataContainerToXML(IDataContainer dc) {
        StringBuilder sb = new StringBuilder("<dataContainer name=\"");
        sb.append(dc.getId().toUniqueName());
        sb.append("\" type=\"");
        sb.append(dc.getType());
        sb.append("\">");
        for (IDataContainer sc : dc.getChildren()) {
            sb.append(NavigationHelper.dataContainerToXML(sc));
        }
        for (INode n : dc.getNodes()) {
            sb.append(NavigationHelper.nodeToXML(n));
        }
        sb.append("</dataContainer>");
        return sb.toString();
    }

    private static String conceptToXML(IConcept concept) {
        StringBuilder sb = new StringBuilder("\n<concept name=\"");
        sb.append(concept.getName());
        sb.append("\"><isA>");
        for (String isA : concept.getIsAs()) {
            sb.append(isA);
            sb.append(" ");
        }
        sb.append("</isA>");
        for (String propName : concept.getPropertyNames()) {
            sb.append("<prop name=\"");
            sb.append(propName);
            sb.append("\" value=\"");
            sb.append(concept.getProperty(propName));
            sb.append("\"/>");
        }
        sb.append("</concept>");
        return sb.toString();
    }

    private static String nodeToXML(INode n) {
        StringBuilder sb = new StringBuilder("\n<node id=\"");
        sb.append(n.getId());
        sb.append("\" confidence=\"");
        sb.append(Float.toString(n.getConfidenceLevel()));
        sb.append("\">");
        IDataItem di = n.getDataItem();
        if (null != di) {
            sb.append(NavigationHelper.dataItemToXML(di));
        }
        sb.append(NavigationHelper.conceptToXML(n.getConcept()));
        for (IEdge e : n.getOutEdges(new String[0])) {
            sb.append(NavigationHelper.edgeToXML(e));
        }
        List<IConcept> vQualifiers = n.getConcept().getQualifiers();
        if (vQualifiers != null && !vQualifiers.isEmpty()) {
            for (IConcept cQualifier : vQualifiers) {
                NavigationHelper.nodePropertyToXML(sb, n, cQualifier.getName());
            }
        }
        sb.append("</node>");
        return sb.toString();
    }

    private static void nodePropertyToXML(StringBuilder sb, INode aNode, String propName) {
        String value = (String)aNode.getProperty(propName);
        if (value != null) {
            sb.append("<prop name=\"");
            sb.append(propName);
            sb.append("\">");
            sb.append(value);
            sb.append("</prop>");
        }
    }

    private static String edgeToXML(IEdge e) {
        StringBuilder sb = new StringBuilder("<edge name=\"");
        if (e.getLabel() != null) {
            sb.append(e.getLabel());
        }
        sb.append("\" wholePart=\"");
        sb.append(e.isWholePart() ? "yes" : "no");
        sb.append("\" card=\"");
        sb.append(e.getCardinality().toString());
        sb.append("\" to=\"");
        sb.append(e.getEnd().getId());
        sb.append("\"/>");
        return sb.toString();
    }

    private static String dataItemToXML(IDataItem di) {
        StringBuilder sb = new StringBuilder("\n<dataItem name=\"");
        sb.append(StringSubstitutionEngine.escapeStringForXML(di.getName()));
        sb.append("\" dType=\"");
        sb.append(di.getDataType());
        IDataItemStats stats = di.getStats();
        sb.append("\" numValues=\"");
        sb.append(Long.toString(stats.count()));
        sb.append("\" numDistincValues=\"");
        sb.append(Long.toString(stats.distinctCount()));
        IValue minVal = stats.minValue();
        IValue maxVal = stats.maxValue();
        if (null != minVal && minVal.getStatus() == ValueStatus.OK) {
            sb.append("\" minValue=\"");
            sb.append(Double.toString(minVal.doubleValue()));
        }
        if (null != maxVal && maxVal.getStatus() == ValueStatus.OK) {
            sb.append("\" maxValue=\"");
            sb.append(Double.toString(maxVal.doubleValue()));
        }
        sb.append("\"/>");
        return sb.toString();
    }

    public List<INode> getDetectedHierarchies() {
        if (this.rootCategories != null) {
            return this.rootCategories;
        }
        ArrayList<INode> keepCategories = new ArrayList<INode>();
        Iterable<INode> nodes = this.mContainer.getModel().getNodes();
        for (INode aNode : nodes) {
            INode identifier;
            if (!aNode.isCategory() || (identifier = NavigationHelper.getIdentifierAttributeFromCategory(aNode)) != null && !identifier.isVisible()) continue;
            Iterable<IEdge> inEdges = aNode.getInEdges(new String[0]);
            boolean addCategory = true;
            for (IEdge inEdge : inEdges) {
                if (!inEdge.isWholePart()) continue;
                addCategory = false;
                break;
            }
            List<INode> hierarchyCategories = NavigationHelper.getPartNodes(aNode);
            for (INode category : hierarchyCategories) {
                identifier = NavigationHelper.getIdentifierAttributeFromCategory(category);
                if (identifier == null || identifier.isVisible()) continue;
                addCategory = false;
                break;
            }
            if (!addCategory) continue;
            keepCategories.add(aNode);
        }
        this.rootCategories = keepCategories;
        return this.rootCategories;
    }

    public INode getDefaultMetric() {
        if (this.mDefaultMetric != null) {
            return this.mDefaultMetric;
        }
        for (INode aNode : this.mContainer.getModel().findNodes(NodeFilters.isMetric())) {
            if (this.mDefaultMetric == null) {
                this.mDefaultMetric = aNode;
                continue;
            }
            if (this.mDefaultMetric.getDataItem().getName().compareTo(aNode.getDataItem().getName()) <= 0) continue;
            this.mDefaultMetric = aNode;
        }
        return this.mDefaultMetric;
    }

    public static boolean isPartOfHierarchy(INode aCategory, INode hierarchyCategory) {
        if (!aCategory.isCategory() || !hierarchyCategory.isCategory()) {
            return false;
        }
        if (aCategory.equals(hierarchyCategory)) {
            return true;
        }
        Iterable<IEdge> inEdges = aCategory.getInEdges(new String[0]);
        for (IEdge edge : inEdges) {
            if (!edge.isWholePart()) continue;
            return NavigationHelper.isPartOfHierarchy(edge.getStart(), hierarchyCategory);
        }
        return false;
    }

    public static boolean canBeAMetric(INode node) {
        if (node.isMetric()) {
            return true;
        }
        IConcept concept = node.getConcept();
        IDataItem di = node.getDataItem();
        boolean numeric = false;
        if (di != null) {
            numeric = di.getDataType().isNumeric();
        }
        if (node.isAttribute() && concept.isCommonAttribute()) {
            INode catNode = NavigationHelper.getCategoryFromAttribute(node);
            concept = catNode.getConcept();
        }
        return concept.supportsClassification(IConcept.EConceptClass.metric) && numeric;
    }

    public static String getDefaultAggregation(INode node) {
        String aggregation;
        IConcept concept = node.getConcept();
        IDataItem di = node.getDataItem();
        boolean numeric = false;
        if (di != null) {
            numeric = di.getDataType().isNumeric();
        }
        if (node.isAttribute() && concept.isCommonAttribute()) {
            INode catNode = NavigationHelper.getCategoryFromAttribute(node);
            concept = catNode.getConcept();
        }
        if ((node.isMetric() || concept.supportsClassification(IConcept.EConceptClass.metric) && numeric) && (aggregation = concept.getProperty("defAggregate")) != null) {
            return aggregation;
        }
        if (node.isMetric()) {
            return EAggregateType.SUM.toString();
        }
        return EAggregateType.COUNT_DISTINCT.toString();
    }

    public static ECatgeorySortOrder getDefaultSortOrder(INode aNode) {
        if (NavigationHelper.hasBinningRanges(aNode)) {
            return ECatgeorySortOrder.ordinal;
        }
        INode nodeSort = NavigationHelper.getApplicableSortOrderNode(aNode);
        if (nodeSort != null && nodeSort.getConcept() != null) {
            Class<?>[] intfsList;
            Object objectOrder = nodeSort.getProperty("TEMPORAL_ORDER_LIST");
            if (objectOrder != null && Arrays.asList(intfsList = objectOrder.getClass().getInterfaces()).contains(List.class)) {
                return ECatgeorySortOrder.ordinal;
            }
            String property = nodeSort.getConcept().getProperty("defSortOrder");
            if (property == null) {
                return ECatgeorySortOrder.ordinal;
            }
            ECatgeorySortOrder eSO = ECatgeorySortOrder.valueOf(property);
            if (!aNode.isDerived() && eSO == ECatgeorySortOrder.ordinal && !NavigationHelper.doValuesMatchKBOrdivalValues(nodeSort)) {
                eSO = ECatgeorySortOrder.ascending;
            }
            return eSO;
        }
        return ECatgeorySortOrder.unknown;
    }

    private static boolean doValuesMatchKBOrdivalValues(INode sortNode) {
        IDataItemStats stats;
        List<IValue> vOrdinals = sortNode.getConcept().getExactValueInstances();
        IDataItem diSort = sortNode.getDataItem();
        if (diSort == null) {
            diSort = NavigationHelper.getDefaultAttributeNode(sortNode).getDataItem();
        }
        if ((stats = diSort.getStats()) == null || vOrdinals == null) {
            return false;
        }
        if (stats.distinctCount() > (long)vOrdinals.size()) {
            return false;
        }
        IValue min = stats.minValue();
        IValue max = stats.maxValue();
        if (min == null || max == null) {
            return true;
        }
        return min.isOK() && !min.isNull() && vOrdinals.contains(min) && max.isOK() && !max.isNull() && vOrdinals.contains(max);
    }

    public static List<IValue> getOrdinalValues(INode aNode) {
        return NavigationHelper.getOrdinalValues(aNode, null);
    }

    public static List<IValue> getOrdinalValues(INode aNode, Locale locale) {
        List<IValue> out = null;
        INode nodeSort = NavigationHelper.getApplicableSortOrderNode(aNode);
        if (nodeSort != null && nodeSort.getConcept() != null) {
            Class<?>[] intfsList;
            Object objectOrder = nodeSort.getProperty("TEMPORAL_ORDER_LIST");
            if (objectOrder != null && Arrays.asList(intfsList = objectOrder.getClass().getInterfaces()).contains(List.class)) {
                return (List)objectOrder;
            }
            out = nodeSort.getConcept().getExactValueInstances();
            if (out == null) {
                out = NavigationHelper.getBinningRanges(aNode, locale);
            }
        } else {
            out = new ArrayList<IValue>();
        }
        return out;
    }

    public static List<IValue> getBinningRanges(INode aNode, Locale locale) {
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        ArrayList<IValue> binnedValues = new ArrayList<IValue>();
        List<IBinningRange> binningRanges = null;
        String sBinned = (String)aNode.getProperty("BINNING_ASSOCIATION_DETAILED");
        if (sBinned != null && !sBinned.isEmpty()) {
            INode binnedNode = aNode.getModel().findNodes(NodeFilters.hasDataItemName(sBinned)).iterator().next();
            if (binnedNode != null && NavigationHelper.isBinningRangedMatchKB(aNode, binnedNode)) {
                binningRanges = binnedNode.getConcept().getBinningRanges(locale);
            }
            if (binningRanges != null) {
                for (IBinningRange br : binningRanges) {
                    binnedValues.add(new StringValue(br.getLocalizedCaption()));
                }
            }
        }
        return binnedValues;
    }

    public static boolean isVisibleToSmarts(IAttribute attr) {
        if (attr != null && attr.getNode() != null) {
            if (NavigationHelper.isRowId(attr)) {
                return true;
            }
            if (attr.isVisible() && attr.getNode().isVisible()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isVisibleToSmarts(INode node) {
        if (node.getModel() == null || node.getModel().getQueryModel() == null) {
            return node.isVisible();
        }
        if (node.isAttribute() || node.isMetric()) {
            for (IAttribute attr : node.getModel().getQueryModel().getQueryAttributes(null)) {
                if (node != attr.getNode() || !NavigationHelper.isVisibleToSmarts(attr)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getName(String uniqueName) {
        try {
            return UniqueNameParser.parseLastIdentifier(uniqueName);
        }
        catch (UniqueNameParserException e) {
            return "";
        }
    }

    public static boolean hasBinningRanges(INode aNode) {
        boolean detailedIsBinned;
        String sBinned = (String)aNode.getProperty("BINNING_ASSOCIATION_DETAILED");
        if (sBinned == null || sBinned.isEmpty()) {
            return false;
        }
        INode binnedNode = aNode.getModel().findNodes(NodeFilters.hasDataItemName(sBinned)).iterator().next();
        boolean bl = detailedIsBinned = binnedNode != null && binnedNode.getConcept().getBinningType() != IConcept.EBinningType.unknown;
        if (detailedIsBinned) {
            return NavigationHelper.isBinningRangedMatchKB(aNode, binnedNode);
        }
        return false;
    }

    private static boolean isBinningRangedMatchKB(INode aNode, INode binnedNode) {
        IDataItemStats stats = aNode.getDataItem().getStats();
        List<IBinningRange> binningRanges = binnedNode.getConcept().getBinningRanges(null);
        if (stats != null && binningRanges != null) {
            if (stats.distinctCount() != (long)binningRanges.size()) {
                return false;
            }
            return NavigationHelper.validate(stats.minValue(), binningRanges.get(0)) && NavigationHelper.validate(stats.maxValue(), binningRanges.get(binningRanges.size() - 1));
        }
        return false;
    }

    private static boolean validate(IValue nodeBinningRange, IBinningRange modelBinningRange) {
        if (nodeBinningRange == null || modelBinningRange == null || modelBinningRange.getLocalizedCaption() == null) {
            return false;
        }
        return modelBinningRange.getLocalizedCaption().equalsIgnoreCase(nodeBinningRange.stringValue());
    }

    private static INode getApplicableSortOrderNode(INode aNode) {
        INode joinNode;
        boolean isCommonAttribute;
        INode out = null;
        boolean bl = isCommonAttribute = aNode.getConcept() != null && aNode.getConcept().isCommonAttribute();
        if (aNode.isAttribute() && !isCommonAttribute || aNode.isCategory()) {
            out = aNode;
        } else if (isCommonAttribute) {
            out = NavigationHelper.getCategoryFromAttribute(aNode);
        }
        if (out != null && (joinNode = (INode)out.getProperty("__joinInput")) != null) {
            return joinNode;
        }
        return out;
    }

    public static IConcept getBestAttributeConcept(IAttribute attr) {
        if (attr != null) {
            return NavigationHelper.getBestNodeConcept(attr.getNode());
        }
        return null;
    }

    public static IConcept getBestNodeConcept(INode node) {
        if (node != null) {
            if (node.isMetric() || node.isCategory()) {
                return node.getConcept();
            }
            if (node.isAttribute()) {
                INode cat;
                if (node.getConcept().isCommonAttribute() && (cat = NavigationHelper.getCategoryFromAttribute(node)) != null) {
                    return cat.getConcept();
                }
                return node.getConcept();
            }
        }
        return null;
    }

    public static IDataContainer getVisibleContainer(IAssociativeModel model) {
        return NavigationHelper.getVisibleContainer(model.getRootContainer());
    }

    public static IDataContainer getVisibleContainer(IDataContainer rootContainer) {
        if (rootContainer.getChildren().isEmpty()) {
            return rootContainer;
        }
        return NavigationHelper.getVisibleSubContainer(rootContainer);
    }

    private static IDataContainer getVisibleSubContainer(IDataContainer rootContainer) {
        for (IDataContainer container : rootContainer.getChildren()) {
            if (container.isVisible()) {
                return container;
            }
            IDataContainer visibleChild = NavigationHelper.getVisibleSubContainer(container);
            if (visibleChild == null) continue;
            return visibleChild;
        }
        return null;
    }

    public static List<INode> getNodesFromVisibleContainer(IAssociativeModel model) {
        IDataContainer visibleContainer = NavigationHelper.getVisibleContainer(model.getRootContainer());
        if (visibleContainer != null) {
            return visibleContainer.getNodes();
        }
        return Collections.emptyList();
    }

    public static Iterable<INode> findNodesFromVisibleContainer(IAssociativeModel model, IFilter<INode> condition) {
        return new FilteringIterable<INode>(NavigationHelper.getNodesFromVisibleContainer(model), condition);
    }

    public static INode findNodeByDataItemNameFromVisibleContainer(IAssociativeModel model, String name) {
        for (INode n : NavigationHelper.getNodesFromVisibleContainer(model)) {
            if (n.getDataItem() == null || n.getDataItem().getName().compareToIgnoreCase(name) != 0) continue;
            return n;
        }
        return null;
    }

    public static IDataItemStats getBaseStatsForNode(INode node) {
        if (node != null && (node.isAttribute() || node.isMetric())) {
            IDataItem dItem;
            IAttribute attribute;
            IQueryModel queryModel;
            INode baseTableNode = node;
            IAssociativeModel model = node.getModel();
            if (model != null && (queryModel = model.getQueryModel()) != null && (attribute = queryModel.getQueryAttributeForNode(node)) != null && attribute.isJoined() && (attribute = ((IJoinAttribute)attribute).getBaseTableAttribute()) != null) {
                baseTableNode = attribute.getNode();
            }
            if ((dItem = baseTableNode.getDataItem()) != null) {
                return dItem.getStats();
            }
        }
        return null;
    }

    public List<INode> getVisibleCategoryAndMetricNodesFiltered(List<String> excludeConcepts) {
        ArrayList<INode> outNodes = new ArrayList<INode>(30);
        this.collectNodesByClass(NavigationHelper.getVisibleContainer(this.mContainer), IConcept.EConceptClass.category, outNodes, excludeConcepts);
        this.collectNodesByClass(NavigationHelper.getVisibleContainer(this.mContainer), IConcept.EConceptClass.metric, outNodes, excludeConcepts);
        return outNodes;
    }

    public static boolean isRowId(IAttribute attribute) {
        return NavigationHelper.isRowId(attribute.getNode());
    }

    public static boolean isRowId(INode node) {
        if (node != null) {
            if (node.isAttribute() && node.getConcept().is("cRowIdentifier")) {
                return true;
            }
            if (node.isSystem() && node.isMetric() && node.getDataItem().getName().endsWith("__row_id__")) {
                return true;
            }
        }
        return false;
    }

    static {
        gSpecialConcepts.add("cDate");
    }

    public static enum ECatgeorySortOrder {
        unknown,
        ascending,
        descending,
        ordinal;

    }
}

