/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model;

import com.ibm.cognos.aurora.api.model.ENodeType;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.core.util.collection.Filters;
import com.ibm.cognos.aurora.core.util.collection.IFilter;

public final class NodeFilters
extends Filters {
    private NodeFilters() {
    }

    public static IFilter<INode> hasNodeId(final String id) {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                return n.getId().equals(id);
            }
        };
    }

    public static IFilter<INode> hasNodeLabel(final String label) {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                if (null == n.getLabel()) {
                    return null == label;
                }
                return n.getLabel().equals(label);
            }
        };
    }

    public static IFilter<INode> hasNodeType(final ENodeType type) {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                return n.getType() == type;
            }
        };
    }

    public static IFilter<INode> isCategory() {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                return n.isCategory();
            }
        };
    }

    public static IFilter<INode> isAttribute() {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                return n.isAttribute();
            }
        };
    }

    public static IFilter<INode> isMetric() {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                return n.isMetric();
            }
        };
    }

    public static IFilter<INode> isIncidentWith(final IEdge edge) {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                return edge.getStart().equals(n) || edge.getEnd().equals(n);
            }
        };
    }

    public static IFilter<INode> isAdjacentWith(final INode other) {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                for (IEdge oe : n.getOutEdges(new String[0])) {
                    if (!oe.getEnd().equals(other)) continue;
                    return true;
                }
                for (IEdge ie : n.getInEdges(new String[0])) {
                    if (!ie.getStart().equals(other)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static IFilter<INode> isSynthetic() {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                return MetadataHelper.isSynthetic(n);
            }
        };
    }

    public static IFilter<INode> hasPropertyValue(final String propName, final Object propValue) {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                Object v = n.getProperty(propName);
                if (null == v) {
                    return null == propValue;
                }
                return v.equals(propValue);
            }
        };
    }

    public static IFilter<INode> hasConcept(final IConcept concept) {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                return n.getConcept() == concept;
            }
        };
    }

    public static IFilter<INode> extendsFromConcept(final IConcept concept) {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                return n.getConcept().is(concept);
            }
        };
    }

    public static IFilter<INode> hasConceptName(final String conceptName) {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                return n.getConcept().getName().equals(conceptName);
            }
        };
    }

    public static IFilter<INode> isInScopeWith(final INode other) {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                return n.isInScopeWith(other);
            }
        };
    }

    public static IFilter<INode> hasDataItem(final IDataItem di) {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                if (null == n.getDataItem()) {
                    return null == di;
                }
                return n.getDataItem().equals(di);
            }
        };
    }

    public static IFilter<INode> findByDataItemId(final IDataItem di) {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                if (null == n.getDataItem()) {
                    return null == di;
                }
                return n.getDataItem().getId().equals(di.getId());
            }
        };
    }

    public static IFilter<INode> hasDataItemName(final String diName) {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                if (null == n.getDataItem()) {
                    return false;
                }
                return n.getDataItem().getName().equals(diName);
            }
        };
    }

    public static IFilter<INode> hasDefaultDataItem(final IDataItem di) {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                IDataItem defaultDI = MetadataHelper.getDefaultDataItem(n);
                return defaultDI.equals(di);
            }
        };
    }

    public static IFilter<INode> hasDefaultDataItemName(final String diName) {
        return new IFilter<INode>(){

            @Override
            public boolean passes(INode n) {
                IDataItem defaultDI = MetadataHelper.getDefaultDataItem(n);
                return defaultDI.getName().equals(diName);
            }
        };
    }
}

