/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.model.format;

import com.ibm.cognos.aurora.core.model.format.FormatPropertyEnum;
import java.util.Map;
import java.util.TreeMap;

public class FormatProperties {
    public static final int UNKNOWN_TYPE = -1;
    public static final int CURRENCY_TYPE = 1;
    public static final int PERCENT_TYPE = 2;
    public static final int NUMBER_TYPE = 3;
    public static final int DATETIME_TYPE = 4;
    private Map<FormatPropertyEnum, Object> properties = new TreeMap<FormatPropertyEnum, Object>();
    private int formatType;

    public FormatProperties() {
        this.formatType = -1;
    }

    public FormatProperties(int type) {
        this.formatType = type;
    }

    public void addProperty(FormatPropertyEnum pName, Object pValue) {
        this.properties.put(pName, pValue);
    }

    public Object getValue(FormatPropertyEnum pName) {
        return this.properties.get((Object)pName);
    }

    public void setFormatType(int type) {
        this.formatType = type;
    }

    public boolean isCurrencyType() {
        return this.formatType == 1;
    }

    public boolean isPercentType() {
        return this.formatType == 2;
    }

    public boolean isNumberType() {
        return this.formatType == 3;
    }

    public boolean isNumericType() {
        return this.isCurrencyType() || this.isPercentType() || this.isNumberType();
    }

    public boolean isDateTimeType() {
        return this.formatType == 4;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FormatProperties)) {
            return false;
        }
        FormatProperties other = (FormatProperties)o;
        return this.properties.entrySet().equals(other.properties.entrySet());
    }

    public int hashCode() {
        return this.properties.entrySet().hashCode();
    }
}

