/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigHelper {
    private static final Pattern LIST_ITEM_PATTERN = Pattern.compile("\\s*\"(.*?)\"\\s*");

    public static String getString(Properties props, String key) {
        return props.getProperty(key);
    }

    public static String getString(Properties props, String key, String defaultValue) {
        String value = props.getProperty(key);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    public static boolean getBoolean(Properties props, String key, boolean defaultValue) {
        String value = props.getProperty(key);
        if (null == value) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public static Boolean getBoolean(Properties props, String key) {
        String value = props.getProperty(key);
        if (null == value) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    public static short getShort(Properties props, String key, short defaultValue) {
        String value = props.getProperty(key);
        if (null == value) {
            return defaultValue;
        }
        return Short.parseShort(value);
    }

    public static Short getShort(Properties props, String key) {
        String value = props.getProperty(key);
        if (null == value) {
            return null;
        }
        return Short.parseShort(value);
    }

    public static int getInteger(Properties props, String key, int defaultValue) {
        String value = props.getProperty(key);
        if (null == value) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static Integer getInteger(Properties props, String key) {
        String value = props.getProperty(key);
        if (null == value) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public static long getLong(Properties props, String key, long defaultValue) {
        String value = props.getProperty(key);
        if (null == value) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public static Long getLong(Properties props, String key) {
        String value = props.getProperty(key);
        if (null == value) {
            return null;
        }
        return Long.parseLong(value);
    }

    public static float getFloat(Properties props, String key, float defaultValue) {
        String value = props.getProperty(key);
        if (null == value) {
            return defaultValue;
        }
        return Float.parseFloat(value);
    }

    public static Float getFloat(Properties props, String key) {
        String value = props.getProperty(key);
        if (null == value) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(value));
    }

    public static double getDouble(Properties props, String key, double defaultValue) {
        String value = props.getProperty(key);
        if (null == value) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public static Double getDouble(Properties props, String key) {
        String value = props.getProperty(key);
        if (null == value) {
            return null;
        }
        return Double.parseDouble(value);
    }

    public static List<String> getList(Properties props, String key) {
        String value = props.getProperty(key);
        if (null == value) {
            return Collections.emptyList();
        }
        LinkedList<String> items = new LinkedList<String>();
        Matcher m = LIST_ITEM_PATTERN.matcher(value);
        while (m.find()) {
            items.add(m.group(1));
        }
        return items;
    }

    protected ConfigHelper() {
        throw new RuntimeException("Cannot instantiate static helper class ConfigHelper");
    }
}

