/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DPHeaderUtility {
    public static Map<String, String> getHeaderPropertiesUnencoded(Map<String, List<String>> headerProperties) {
        HashMap<String, String> fixedHeaders = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : headerProperties.entrySet()) {
            String valueUnencoded;
            String value = entry.getValue().get(0);
            try {
                valueUnencoded = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedOperationException("The encoding type was not supported", e);
            }
            fixedHeaders.put(entry.getKey(), valueUnencoded);
        }
        return fixedHeaders;
    }

    public static URI getBaGateWayUri(Map<String, List<String>> requestHeaders) {
        String gateWayHeader = DPHeaderUtility.getBAHeader(requestHeaders);
        if (StringUtils.isEmpty((String)gateWayHeader)) {
            return null;
        }
        String[] splitTokens = gateWayHeader.split(";");
        String fullUrl = DPHeaderUtility.findParameter("location", splitTokens);
        String loadBalancer = DPHeaderUtility.findParameter("lbpath", splitTokens);
        URI uri = DPHeaderUtility.getInitialURI(fullUrl);
        uri = DPHeaderUtility.updateURIWithDefaultsAndLoadBalancer(uri, loadBalancer);
        return uri;
    }

    private static String getBAHeader(Map<String, List<String>> requestHeaders) {
        List<String> gateWayHeaderEncodedList = requestHeaders.get("ba-watson-gateway");
        if (gateWayHeaderEncodedList == null) {
            return "";
        }
        try {
            return URLDecoder.decode(gateWayHeaderEncodedList.get(0), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("The encoding type was not supported", e);
        }
    }

    private static String findParameter(String paramName, String[] splitTokens) {
        for (String token : splitTokens) {
            if (!token.startsWith(paramName)) continue;
            return token.substring(paramName.length() + 1);
        }
        return "";
    }

    private static URI updateURIWithDefaultsAndLoadBalancer(URI uri, String loadBalancer) {
        String host = DPHeaderUtility.stripSlashIfExists(uri.getHost());
        String scheme = uri.getScheme() == null ? "http" : uri.getScheme();
        int port = DPHeaderUtility.getPort(uri);
        try {
            uri = new URI(scheme, null, host, port, loadBalancer, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return uri;
    }

    private static URI getInitialURI(String fullUrl) {
        URI uri = null;
        fullUrl = DPHeaderUtility.stripSlashIfExists(fullUrl);
        try {
            uri = new URI(fullUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        if (uri.getHost() == null) {
            throw new IllegalArgumentException("Gateway header passed in was: " + fullUrl + ". We could not parse the host of this URL");
        }
        return uri;
    }

    private static String stripSlashIfExists(String s) {
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static int getPort(URI uri) {
        if (uri.getPort() != -1) {
            return uri.getPort();
        }
        String scheme = uri.getScheme();
        int defaultPort = 80;
        if (scheme != null && scheme.compareTo("https") == 0) {
            defaultPort = 443;
        }
        return defaultPort;
    }
}

