/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.util.IPooledObjectFactory;
import com.ibm.cognos.aurora.core.util.IReleasable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GenericObjectCache<T extends IReleasable> {
    public static final ILogger LOG = LoggerManager.getLogger("ATHENA.core");
    private static final long MAX_EXPIRE = TimeUnit.HOURS.toMillis(2L);
    private final long mExpire;
    private final long mMaxExpire;
    private volatile Date mLastCheck;
    private final ConcurrentHashMap<String, PooledObject> mCache = new ConcurrentHashMap();

    public GenericObjectCache(long expirePeriodMS) {
        this(expirePeriodMS, MAX_EXPIRE);
    }

    public GenericObjectCache(long expirePeriodMS, long maxExpirePeriodMS) {
        this.mExpire = expirePeriodMS;
        this.mMaxExpire = maxExpirePeriodMS;
        this.mLastCheck = new Date();
        LOG.info("Creating new cache with default expiration: " + expirePeriodMS, "GenericObjectCache");
    }

    public void clear() {
        LOG.info("Clearing object cache.", "GenericObjectCache");
        Iterator<Map.Entry<String, PooledObject>> itr = this.mCache.entrySet().iterator();
        while (itr.hasNext()) {
            PooledObject obj = itr.next().getValue();
            itr.remove();
            obj.release();
        }
    }

    public int size() {
        this.releaseExpired();
        return this.mCache.size();
    }

    public int getRefCount(String key) {
        this.releaseExpired();
        PooledObject entry = this.mCache.get(key);
        if (entry != null) {
            return entry.refCount();
        }
        return 0;
    }

    public T borrow(String key, IPooledObjectFactory<T> factory) {
        this.releaseExpired();
        PooledObject entry = this.mCache.get(key);
        if (entry == null) {
            IReleasable obj = (IReleasable)factory.create();
            PooledObject newObj = new PooledObject(this, obj);
            PooledObject existing = this.mCache.putIfAbsent(key, newObj);
            if (existing != null) {
                newObj.release();
                entry = existing;
            } else {
                entry = newObj;
            }
            LOG.info("Creating new object: " + entry, "GenericObjectCache");
        } else {
            LOG.info("Returning cached object: " + entry, "GenericObjectCache");
        }
        entry.update();
        entry.increment();
        return (T)entry.get();
    }

    public void putBack(T obj) {
        this.putBack(null, obj);
    }

    public void putBack(String key, T obj) {
        if (key != null) {
            PooledObject entry = this.mCache.get(key);
            if (entry != null) {
                entry.decrement();
                entry.update();
            }
        } else {
            for (PooledObject o : this.mCache.values()) {
                if (o.get() != obj) continue;
                o.decrement();
                o.update();
            }
        }
    }

    public List<T> releaseExpired() {
        ArrayList<IReleasable> expired = new ArrayList<IReleasable>();
        Date current = this.currentDate();
        if (GenericObjectCache.expired(current, this.mLastCheck, this.mExpire)) {
            Iterator<Map.Entry<String, PooledObject>> itr = this.mCache.entrySet().iterator();
            while (itr.hasNext()) {
                PooledObject obj = itr.next().getValue();
                if ((obj.refCount() != 0 || !GenericObjectCache.expired(current, obj.lastUsed(), this.mExpire)) && !GenericObjectCache.expired(current, obj.lastUsed(), this.mMaxExpire)) continue;
                itr.remove();
                obj.release();
                expired.add(obj.get());
                LOG.info("Removing expired object: " + obj, "GenericObjectCache");
            }
            this.mLastCheck = current;
        }
        return expired;
    }

    private static boolean expired(Date current, Date lastUpdate, long expirePeriod) {
        return current.getTime() - lastUpdate.getTime() > expirePeriod;
    }

    private Date currentDate() {
        return new Date();
    }

    private static final class PooledObject {
        private volatile Date mLastUsed = new Date();
        private final AtomicInteger mRef = new AtomicInteger(0);
        private final T mObj;
        final /* synthetic */ GenericObjectCache this$0;

        private PooledObject(T obj) {
            this.this$0 = var1_1;
            this.mObj = obj;
        }

        private T get() {
            return this.mObj;
        }

        private int increment() {
            return this.mRef.incrementAndGet();
        }

        private int decrement() {
            return this.mRef.decrementAndGet();
        }

        private int refCount() {
            return this.mRef.get();
        }

        private Date lastUsed() {
            return this.mLastUsed;
        }

        private void update() {
            this.mLastUsed = new Date();
        }

        private void release() {
            this.mObj.release();
        }

        public String toString() {
            return this.mObj.toString();
        }
    }
}

