/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

import java.util.Locale;

public class LocaleUtil {
    public static String localeToString(Locale locale) {
        if (locale.getCountry().length() == 0) {
            return locale.getLanguage();
        }
        return String.format("%s-%s", locale.getLanguage(), locale.getCountry());
    }

    public static Locale localeFromString(String localeString) {
        int separatorPos = localeString.indexOf(45);
        if (separatorPos == -1) {
            separatorPos = localeString.indexOf(95);
        }
        String lang = null;
        String country = null;
        if (separatorPos != -1) {
            lang = localeString.substring(0, separatorPos);
            if (lang.length() != 2) {
                throw new IllegalArgumentException("language was not two letters");
            }
            country = localeString.substring(separatorPos + 1);
            if (country.length() != 2) {
                throw new IllegalArgumentException("country was not two letters");
            }
        } else if (localeString.length() > 0 && (lang = localeString).length() != 2) {
            throw new IllegalArgumentException("language was not two letters");
        }
        if (null != country) {
            return new Locale(lang.toLowerCase(), country.toUpperCase());
        }
        if (null != lang) {
            return new Locale(lang.toLowerCase());
        }
        throw new IllegalArgumentException("locale was empty");
    }

    protected LocaleUtil() {
        throw new RuntimeException("LocaleUtil static utility clas sshould not be instantiated");
    }
}

