/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

import com.ibm.cognos.aurora.core.util.RunnableScheduledFutureWrapper;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SafeScheduledThreadPoolExecutor {
    private final ScheduledThreadPoolExecutor safeRunnableScheduledTaskExecutor;
    private final ThreadPoolExecutor unsafeRunnableExecutor;
    private final ExecutorCompletionService<?> unsafeRunnableExecutorCompletionService;

    public SafeScheduledThreadPoolExecutor(long keepAliveTime, TimeUnit timeUnit, String threadBaseName) {
        this(keepAliveTime, timeUnit, threadBaseName, SafeScheduledThreadPoolExecutor.createThreadFactory(threadBaseName));
    }

    public SafeScheduledThreadPoolExecutor(long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory) {
        this(keepAliveTime, timeUnit, "SafeScheduledThreadPoolExecutor", threadFactory);
    }

    public SafeScheduledThreadPoolExecutor(long keepAliveTime, TimeUnit timeUnit, String threadName, ThreadFactory threadFactory) {
        this.safeRunnableScheduledTaskExecutor = new CustomScheduledThreadPoolExecutor(threadName, keepAliveTime, timeUnit);
        this.unsafeRunnableExecutor = new CachedThreadPoolExecutor(threadFactory, keepAliveTime, timeUnit);
        this.unsafeRunnableExecutorCompletionService = new ExecutorCompletionService(this.unsafeRunnableExecutor);
    }

    protected SafeScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor safeRunnableScheduledTaskExecutor, ThreadPoolExecutor unsafeRunnableExecutor, ExecutorCompletionService<?> unsafeRunnableExecutorCompletionService) {
        this.safeRunnableScheduledTaskExecutor = safeRunnableScheduledTaskExecutor;
        this.unsafeRunnableExecutor = unsafeRunnableExecutor;
        this.unsafeRunnableExecutorCompletionService = unsafeRunnableExecutorCompletionService;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable unsafeRunnable, long initialDelay, long periodTime, TimeUnit timeUnit, IErrorHandler errorHandler) {
        return this.safeRunnableScheduledTaskExecutor.scheduleAtFixedRate(new SafeRunnable(unsafeRunnable, errorHandler), initialDelay, periodTime, timeUnit);
    }

    public int getSafePoolSize() {
        return this.safeRunnableScheduledTaskExecutor.getPoolSize();
    }

    public int getPoolSize() {
        return this.unsafeRunnableExecutor.getPoolSize();
    }

    boolean remove(Runnable task) {
        return this.safeRunnableScheduledTaskExecutor.remove(task);
    }

    public int getLargestPoolSize() {
        return this.unsafeRunnableExecutor.getLargestPoolSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.safeRunnableScheduledTaskExecutor.shutdown();
        }
        finally {
            this.unsafeRunnableExecutor.shutdown();
        }
    }

    public boolean isShutdown() {
        return this.safeRunnableScheduledTaskExecutor.isShutdown() || this.unsafeRunnableExecutor.isShutdown();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.safeRunnableScheduledTaskExecutor.awaitTermination(timeout, unit) && this.unsafeRunnableExecutor.awaitTermination(timeout, unit);
    }

    private static ThreadFactory createThreadFactory(final String threadBaseName) {
        return new ThreadFactory(){
            final AtomicInteger threadId = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, threadBaseName + '-' + this.threadId.incrementAndGet());
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public static interface IErrorHandler {
        public void onPreviousRunStillRunning();
    }

    private static class CachedThreadPoolExecutor
    extends ThreadPoolExecutor {
        private static final int INITIAL_CORE_POOL_SIZE = 0;
        private static final int MAXIMUM_POOL_SIZE = Integer.MAX_VALUE;

        CachedThreadPoolExecutor(ThreadFactory threadFactory, long keepAliveTime, TimeUnit timeUnit) {
            super(0, Integer.MAX_VALUE, keepAliveTime, timeUnit, new SynchronousQueue<Runnable>(), threadFactory);
            this.allowCoreThreadTimeOut(true);
        }
    }

    private class CustomScheduledThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        private static final int ONE_THREAD = 1;

        CustomScheduledThreadPoolExecutor(final String threadName, long keepAliveTime, TimeUnit timeUnit) {
            super(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, threadName);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.setKeepAliveTime(keepAliveTime, timeUnit);
            this.allowCoreThreadTimeOut(true);
            this.setMaximumPoolSize(1);
        }

        @Override
        protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
            SafeRunnable safeRunnable = (SafeRunnable)runnable;
            return new SafeRunnableScheduledFuture<V>(SafeScheduledThreadPoolExecutor.this, safeRunnable, task);
        }
    }

    private class SafeRunnableScheduledFuture<V>
    extends RunnableScheduledFutureWrapper<V> {
        private final SafeRunnable safeRunnable;

        SafeRunnableScheduledFuture(SafeScheduledThreadPoolExecutor safeScheduledThreadPoolExecutor2, SafeRunnable safeRunnable, RunnableScheduledFuture<V> task) {
            super(task);
            this.safeRunnable = safeRunnable;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.safeRunnable.cancelUnsafeRunnable(mayInterruptIfRunning);
            return super.cancel(mayInterruptIfRunning);
        }
    }

    private class SafeRunnable
    implements Runnable {
        private final Runnable unsafeRunnable;
        private final IErrorHandler errorHandler;
        private volatile boolean cancelled;
        private Future<?> runningFuture;

        SafeRunnable(Runnable unsafeRunnable, IErrorHandler errorHandler) {
            this.unsafeRunnable = unsafeRunnable;
            this.errorHandler = errorHandler;
            this.runningFuture = null;
            this.cancelled = false;
        }

        @Override
        public void run() {
            boolean error = this.submitRun();
            if (error) {
                this.errorHandler.onPreviousRunStillRunning();
            }
        }

        private synchronized boolean submitRun() {
            if (!this.cancelled) {
                if (null != this.runningFuture && !this.runningFuture.isDone()) {
                    return true;
                }
                this.runningFuture = SafeScheduledThreadPoolExecutor.this.unsafeRunnableExecutorCompletionService.submit(this.unsafeRunnable, null);
            }
            return false;
        }

        void cancelUnsafeRunnable(boolean mayInterruptIfRunning) {
            Future<?> runningFuture = this.cancelRun();
            if (null != runningFuture) {
                runningFuture.cancel(mayInterruptIfRunning);
            }
        }

        private synchronized Future<?> cancelRun() {
            this.cancelled = true;
            return this.runningFuture;
        }
    }
}

