/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.exception.LocalizedRuntimeException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class SingletonHelper<T> {
    private volatile T mInstance = null;
    private final Lock mInitLock = new ReentrantLock();
    private final AtomicBoolean mInitInProgress = new AtomicBoolean(false);

    public final T getInstance() {
        return this.getInstance(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getInstance(boolean noInit) {
        if (null != this.mInstance) {
            return this.mInstance;
        }
        if (noInit) {
            return null;
        }
        this.mInitLock.lock();
        try {
            if (null != this.mInstance) {
                T t = this.mInstance;
                return t;
            }
            if (!this.mInitInProgress.compareAndSet(false, true)) {
                throw new LocalizedRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "Recursive initialization detected for singleton.");
            }
            try {
                T temp = this.newInstance();
                this.initializeImpl(temp);
                this.mInstance = temp;
            }
            finally {
                this.mInitInProgress.set(false);
            }
        }
        finally {
            this.mInitLock.unlock();
        }
        return this.mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseInstance() {
        T temp = null;
        this.mInitLock.lock();
        try {
            temp = this.mInstance;
            this.mInstance = null;
        }
        finally {
            this.mInitLock.unlock();
        }
        if (null != temp) {
            this.releaseImpl(temp);
        }
    }

    protected abstract T newInstance();

    protected abstract void initializeImpl(T var1);

    protected abstract void releaseImpl(T var1);
}

