/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

import com.ibm.cognos.aurora.core.util.IAssociativeContainer;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SoftReferenceCache<K, V>
implements IAssociativeContainer<K, V> {
    private final Map<K, Ref<K, V>> mMap = new HashMap<K, Ref<K, V>>();
    private final ReferenceQueue<V> mRefQueue = new ReferenceQueue();

    public boolean isEmpty() {
        this.cleanup();
        return this.mMap.isEmpty();
    }

    @Override
    public int size() {
        this.cleanup();
        return this.mMap.size();
    }

    public boolean containsKey(K key) {
        this.cleanup();
        return this.mMap.containsKey(key);
    }

    public boolean containsValue(V value) {
        this.cleanup();
        for (Ref<K, V> ref : this.mMap.values()) {
            Object v = ref.get();
            if (null == v || !v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(K key) {
        this.cleanup();
        Ref<K, V> ref = this.mMap.get(key);
        if (null != ref) {
            return (V)ref.get();
        }
        return null;
    }

    @Override
    public Collection<V> values() {
        this.cleanup();
        ArrayList values = new ArrayList(this.size());
        for (Ref<K, V> ref : this.mMap.values()) {
            Object value = ref.get();
            if (null == value) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public V put(K key, V value) {
        if (null == value) {
            throw new NullPointerException("SoftReferenceCache does not support 'null' values");
        }
        this.cleanup();
        Ref<K, V> ref = this.mMap.put(key, new Ref<K, V>(key, value, this.mRefQueue));
        if (null != ref) {
            Object oldValue = ref.get();
            ref.clear();
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public V remove(K key) {
        this.cleanup();
        Ref<K, V> ref = this.mMap.remove(key);
        if (null != ref) {
            Object oldValue = ref.get();
            ref.clear();
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public void clear() {
        this.cleanup();
        for (Ref<K, V> ref : this.mMap.values()) {
            ref.clear();
        }
        this.mMap.clear();
    }

    private void cleanup() {
        Ref ref = (Ref)this.mRefQueue.poll();
        while (null != ref) {
            Object key = ref.mKey;
            this.mMap.remove(key);
            ref = (Ref)this.mRefQueue.poll();
        }
    }

    private static final class Ref<K, V>
    extends SoftReference<V> {
        final K mKey;

        Ref(K key, V referent, ReferenceQueue<V> refQueue) {
            super(referent, refQueue);
            this.mKey = key;
        }
    }
}

