/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

import java.util.Map;
import java.util.Set;

public class StringSubstitutionEngine {
    private static final String SEMI_COLON = ";";
    private static final String XML_CONST_PREFIX = "&#";
    private static final int ASCII_32 = 32;
    private static final int ASCII_127 = 127;
    private static final String QUOTE = "'";

    protected StringSubstitutionEngine() {
        throw new RuntimeException("Cannot instantiate static helper class StringSubstitutionEngine");
    }

    public static String substitute(String source, String oldString, String newString) {
        return StringSubstitutionEngine.replaceAll(source, oldString, newString);
    }

    public static String substitute(String source, Map<String, String> params) {
        if (source == null || source.length() == 0) {
            return source;
        }
        String result = source;
        Set<Map.Entry<String, String>> set = params.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String key = entry.getKey().toString();
            if (result.indexOf(key) == -1) continue;
            result = result.replaceAll(key, entry.getValue().toString());
        }
        return result;
    }

    private static String escapeString(String s, EscapeMode mode) {
        if (s == null || s.length() == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int len = s.length();
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    if (mode != EscapeMode.HTML) {
                        str.append("&quot;");
                        continue block7;
                    }
                    str.append("\"");
                    continue block7;
                }
                case '\'': {
                    str.append("&apos;");
                    continue block7;
                }
                default: {
                    char ival = ch;
                    if (mode == EscapeMode.XML_UNICODE && (ival < ' ' || ival > '\u007f')) {
                        char ch2;
                        if (Character.isHighSurrogate(ch) && i + 1 < s.length() && Character.isLowSurrogate(ch2 = s.charAt(i + 1))) {
                            str.append(XML_CONST_PREFIX);
                            str.append(String.valueOf(Character.toCodePoint(ch, ch2)));
                            str.append(SEMI_COLON);
                            ++i;
                            continue block7;
                        }
                        str.append(XML_CONST_PREFIX);
                        str.append(String.valueOf((int)ival));
                        str.append(SEMI_COLON);
                        continue block7;
                    }
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static String escapeSQLString(String s) {
        return s.replaceAll(QUOTE, "''");
    }

    public static String escapeStringForXML(String s) {
        return StringSubstitutionEngine.escapeString(s, EscapeMode.XML);
    }

    public static String escapeStringForXMLUnicode(String s) {
        return StringSubstitutionEngine.escapeString(s, EscapeMode.XML_UNICODE);
    }

    public static String escapeStringForHTML(String s) {
        return StringSubstitutionEngine.escapeString(s, EscapeMode.HTML);
    }

    public static String replaceAll(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        boolean foundMatch = false;
        if (pattern.length() == 0) {
            return str;
        }
        while ((e = str.indexOf(pattern, s)) >= 0) {
            foundMatch = true;
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        if (!foundMatch) {
            return str;
        }
        result.append(str.substring(s));
        return result.toString();
    }

    static enum EscapeMode {
        XML,
        HTML,
        XML_UNICODE;

    }
}

