/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.StringValue;

public class UniqueNameGenerator {
    public static final String OPEN_BRACE = "[";
    public static final String CLOSE_BRACE = "]";
    public static final String BRACE_DOT = "].";
    public static final String DOT_SEPARATOR = "].[";
    public static final String DOT = ".";
    public static final String ARROW = "->";
    public static final String COLON = ":";
    public static final String ESCAPED_RIGHT_SQUARE_BRACKET = "]]";

    protected UniqueNameGenerator() {
        throw new RuntimeException("Cannot instantiate static helper class UniqueNameGenerator");
    }

    public static String appendUniqueName(String part1, String part2) {
        StringBuilder buffer = new StringBuilder(part1);
        buffer.append(DOT);
        buffer.append(UniqueNameGenerator.createSingleNamePart(part2));
        return buffer.toString();
    }

    public static String createSingleNamePart(String part1) {
        StringBuilder buffer = new StringBuilder();
        UniqueNameGenerator.appendSingleNamePart(buffer, part1);
        return buffer.toString();
    }

    public static void appendSingleNamePart(StringBuilder buffer, String part1) {
        buffer.append(OPEN_BRACE);
        if (part1 != null) {
            buffer.append(part1.replaceAll(CLOSE_BRACE, ESCAPED_RIGHT_SQUARE_BRACKET));
        }
        buffer.append(CLOSE_BRACE);
    }

    public static String createUniqueName(String part1, String part2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(part1);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part2);
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createUniqueName(String part1, String part2, String part3) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(part1);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part2);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part3);
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createUniqueName(String part1, String part2, String part3, String part4) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(part1);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part2);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part3);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part4);
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createUniqueName(String ... parts) {
        StringBuilder buffer = new StringBuilder();
        int lastPart = parts.length - 1;
        for (int i = 0; i < lastPart; ++i) {
            UniqueNameGenerator.appendSingleNamePart(buffer, parts[i]);
            buffer.append(DOT);
        }
        UniqueNameGenerator.appendSingleNamePart(buffer, parts[lastPart]);
        return buffer.toString();
    }

    public static String join(String part1, String part2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(part1);
        buffer.append(DOT);
        buffer.append(part2);
        return buffer.toString();
    }

    public static IValue[] getMemberValues(IMember member) {
        return UniqueNameGenerator.getMemberValues(member.getUniqueName());
    }

    public static IValue[] getMemberValues(String uniqueName) {
        String[] parts = UniqueNameGenerator.splitModelLogicalPhysicalParts(uniqueName);
        String logical = parts[1];
        parts = logical.split("\\.");
        IValue[] values = new IValue[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i];
            part = part.substring(1, part.length() - 1);
            values[i - 1] = new StringValue(UniqueNameGenerator.undoEscapedSquareBracket(part));
        }
        return values;
    }

    public static String[] splitModelLogicalPhysicalParts(String uniqueName) {
        String[] split;
        String physical = null;
        if (uniqueName.contains(COLON)) {
            split = uniqueName.split(COLON);
            physical = split[1];
        }
        if (!uniqueName.contains(ARROW)) {
            throw new IllegalArgumentException("MUN does not contain an ->");
        }
        split = uniqueName.split(ARROW);
        String model = split[0];
        String logical = split[1];
        return new String[]{model, logical, physical};
    }

    public static String undoEscapedSquareBracket(String identifier) {
        return identifier.replaceAll(ESCAPED_RIGHT_SQUARE_BRACKET, CLOSE_BRACE);
    }
}

