/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util;

import com.ibm.cognos.aurora.core.util.UniqueNameParserException;
import java.util.ArrayList;

public class UniqueNameParser {
    private static final int LENGTHDOTSEPS = 3;
    private static final String RIGHT_SQUARE_BRACKET = "]";
    public static final String ESCAPED_RIGHT_SQUARE_BRACKET = "]]";

    public static String parseLastIdentifier(String uniqueName) throws UniqueNameParserException {
        int beginIndex = uniqueName.lastIndexOf("].&[");
        int lengthSeparator = 4;
        if (beginIndex < 0) {
            beginIndex = uniqueName.lastIndexOf("].[");
            lengthSeparator = 3;
        }
        beginIndex = beginIndex < 0 ? ((beginIndex = uniqueName.lastIndexOf(91)) >= 0 ? ++beginIndex : 0) : (beginIndex += lengthSeparator);
        int endIndex = uniqueName.length();
        if (uniqueName.endsWith(RIGHT_SQUARE_BRACKET)) {
            --endIndex;
        }
        return uniqueName.substring(beginIndex, endIndex);
    }

    public static String[] parse(String aUniqueName) throws UniqueNameParserException {
        return UniqueNameParser.parse(aUniqueName, -1);
    }

    public static String parserFirstIdentifier(String aUniqueName) throws UniqueNameParserException {
        String[] result = UniqueNameParser.parse(aUniqueName, 1);
        if (result != null && result.length > 0) {
            return result[0];
        }
        return null;
    }

    public static String[] parse(String aUniqueName, int count) throws UniqueNameParserException {
        char ch;
        StringBuilder str = null;
        int pointer = 0;
        String uniqueName = aUniqueName.trim();
        ArrayList<String> names = new ArrayList<String>();
        if ((ch = UniqueNameParser.nextChar(pointer++, uniqueName)) == '\u0000') {
            UniqueNameParser.throwException("UNIQUE_NAME_EMPTY", uniqueName);
        }
        int counter = 0;
        while (ch != '\u0000' && (count == -1 || counter < count)) {
            if (str == null) {
                if (ch == '[') {
                    str = new StringBuilder("");
                } else if (ch == '&') {
                    ++counter;
                    --counter;
                } else if (ch == '.') {
                    names.add("");
                    ++counter;
                    str = null;
                } else {
                    UniqueNameParser.throwException("UNEXPECTED_CHAR", Character.toString(ch));
                }
            } else if (ch == ']') {
                ch = UniqueNameParser.nextChar(pointer, uniqueName);
                if (ch == '\u0000') {
                    names.add(str.toString());
                    ++counter;
                    str = null;
                } else {
                    ++pointer;
                    if (ch == ']') {
                        str.append(ch);
                    } else if (ch == '.') {
                        names.add(str.toString());
                        ++counter;
                        str = null;
                    } else {
                        UniqueNameParser.throwException("UNEXPECTED_CHAR", Character.toString(ch));
                    }
                }
            } else {
                str.append(ch);
            }
            if ((ch = UniqueNameParser.nextChar(pointer, uniqueName)) == '\u0000') continue;
            ++pointer;
        }
        if (str != null) {
            UniqueNameParser.throwException("UNEXPECTED_ID_END", uniqueName);
        }
        String[] result = names.toArray(new String[names.size()]);
        return result;
    }

    private static char nextChar(int pointer, String uniqueName) {
        if (pointer == uniqueName.length()) {
            return '\u0000';
        }
        return uniqueName.charAt(pointer);
    }

    private static void throwException(String reason, String uniqueName) throws UniqueNameParserException {
        throw new UniqueNameParserException(String.format("%s: %s", reason, uniqueName));
    }

    public static String undoEscapedSquareBracket(String identifier) {
        return identifier.replaceAll(ESCAPED_RIGHT_SQUARE_BRACKET, RIGHT_SQUARE_BRACKET);
    }

    public static String escapeSquareBrackets(String identifier) {
        return identifier.replaceAll(RIGHT_SQUARE_BRACKET, ESCAPED_RIGHT_SQUARE_BRACKET);
    }

    private UniqueNameParser() {
    }
}

