/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.util.collection;

import com.ibm.cognos.aurora.core.util.collection.IFilter;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class FilteringIterator<E>
implements Iterator<E> {
    private final Iterator<E> mSource;
    private final IFilter<E> mFilter;
    private E mNext;

    public FilteringIterator(Iterator<E> source, IFilter<E> filter) {
        this.mSource = source;
        this.mFilter = filter;
        this.mNext = this.fetchNext();
    }

    @Override
    public boolean hasNext() {
        return null != this.mNext;
    }

    @Override
    public E next() {
        if (null == this.mNext) {
            throw new NoSuchElementException();
        }
        E tmp = this.mNext;
        this.mNext = this.fetchNext();
        return tmp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private E fetchNext() {
        while (this.mSource.hasNext()) {
            E e = this.mSource.next();
            if (!this.mFilter.passes(e)) continue;
            return e;
        }
        return null;
    }
}

