/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public final class DOM4JUtil {
    public static final DocumentFactory DOCUMENT_FACTORY = DocumentFactory.getInstance();

    public static Document createDocument() {
        return DOCUMENT_FACTORY.createDocument();
    }

    public static Document createDocument(String encoding) {
        return DOCUMENT_FACTORY.createDocument(encoding);
    }

    public static Document parseDocument(String str) throws DocumentException {
        SAXReader reader = new SAXReader();
        return reader.read(str);
    }

    public static Document parseDocument(InputStream is) throws DocumentException {
        SAXReader reader = new SAXReader();
        return reader.read(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseDocument(File file) throws IOException, DocumentException {
        FileInputStream is = new FileInputStream(file);
        try {
            Document document = DOM4JUtil.parseDocument(is);
            return document;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static void serializeDocument(OutputStream os, Document doc, boolean prettyPrint) throws IOException {
        OutputFormat format = prettyPrint ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
        XMLWriter writer = new XMLWriter(os, format);
        writer.write(doc);
        writer.flush();
    }

    public static void serializeDocument(Writer writer, Document doc, boolean prettyPrint) throws IOException {
        OutputFormat format = prettyPrint ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
        XMLWriter xmlWriter = new XMLWriter(writer, format);
        xmlWriter.write(doc);
        xmlWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeDocument(File file, Document doc, boolean prettyPrint) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            DOM4JUtil.serializeDocument(os, doc, prettyPrint);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static List<Element> elementsOf(Element elem) {
        return elem.elements();
    }

    public static List<Element> elementsOf(Element elem, String name) {
        return elem.elements(name);
    }

    private DOM4JUtil() {
    }
}

