/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.neo.blobstore.IBlobStore;
import com.ibm.neo.dataimport.api.EImportMessageCode;
import com.ibm.neo.dataimport.api.WAImportException;
import com.ibm.neo.dataimport.cdf.DocumentType;
import com.ibm.neo.dataimport.cdf.scrape.IDocumentScraper;
import com.ibm.neo.dataimport.cdf.scrape.IDocumentScraperFactory;
import com.ibm.neo.dataimport.cdf.scrape.ScrapeOptions;
import com.ibm.neo.dataimport.cdf.scrape.ScrapeResult;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetLibrary;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetLibraryFactory;
import com.ibm.neo.dataimport.cdf.util.PreInitializeICU4JClasses;
import com.ibm.neo.exception.MissingRequiredPropertyException;
import com.ibm.neo.exception.WatsonMessageContext;
import com.ibm.neo.messages.exceptions.NeoImportError;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDFService {
    private static final Logger LOG = LoggerFactory.getLogger(CDFService.class);
    public static final String PROP_SHEET_LIB_FACTORY = "com.ibm.neo.dataimport.sheet.library.factory";
    public static final String PROP_SHEET_DATA_DIR = "com.ibm.neo.dataimport.sheet.data-dir";
    public static final String PROP_XLSX_SST_CHARS_MEM = "com.ibm.neo.dataimport.xlsx-sst-chars-mem";
    private static final int DEFAULT_XLSX_SST_CHARS_MEM = 0x3200000;
    private final Properties mConfiguration;
    private final ICDFSheetLibrary mSheetLibrary;
    private final File mSheetDataDir;
    private int mXLSXSSTCharsMem = 0x3200000;
    private final IBlobStore mBlobStore;
    private boolean mDisposed = false;
    private final ConcurrentHashMap<DocumentType, IDocumentScraperFactory> mDocType2ScraperFactory = new ConcurrentHashMap();

    public CDFService(Properties configuration, IBlobStore blobStore) throws Exception {
        this.mConfiguration = configuration;
        this.mBlobStore = blobStore;
        String sheetLibFactoryClassStr = configuration.getProperty(PROP_SHEET_LIB_FACTORY);
        String sheetDataDirStr = configuration.getProperty(PROP_SHEET_DATA_DIR);
        String XLSXSSTCharsMem = configuration.getProperty(PROP_XLSX_SST_CHARS_MEM);
        if (null == sheetLibFactoryClassStr) {
            throw new MissingRequiredPropertyException(PROP_SHEET_LIB_FACTORY);
        }
        if (null == sheetDataDirStr) {
            throw new MissingRequiredPropertyException(PROP_SHEET_DATA_DIR);
        }
        if (null != XLSXSSTCharsMem) {
            this.mXLSXSSTCharsMem = Integer.parseInt(XLSXSSTCharsMem);
        }
        this.mSheetDataDir = new File(sheetDataDirStr);
        if (!this.mSheetDataDir.exists()) {
            FileUtils.forceMkdir((File)this.mSheetDataDir);
        }
        Class<?> sheetLibFactoryClazz = Class.forName(sheetLibFactoryClassStr);
        ICDFSheetLibraryFactory sheetLibFactory = (ICDFSheetLibraryFactory)sheetLibFactoryClazz.newInstance();
        this.mSheetLibrary = sheetLibFactory.create(this);
        for (IDocumentScraperFactory factory : ServiceLoader.load(IDocumentScraperFactory.class)) {
            for (DocumentType docType : factory.getSupportedDocumentTypes(this.mConfiguration)) {
                this.registerDocumentType(docType, factory);
            }
        }
    }

    public Properties getConfiguration() {
        return this.mConfiguration;
    }

    public IBlobStore getBlobStore() {
        return this.mBlobStore;
    }

    public ICDFSheetLibrary getSheetLibrary() {
        return this.mSheetLibrary;
    }

    public File getSheetCacheDir() {
        return this.mSheetDataDir;
    }

    public int getXLSXSSTCharsMem() {
        return this.mXLSXSSTCharsMem;
    }

    public void registerDocumentType(DocumentType docType, IDocumentScraperFactory scraperFactory) {
        if (null == docType) {
            throw new NullArgumentException("docType");
        }
        if (null == scraperFactory) {
            throw new NullArgumentException("scraperFactory");
        }
        if (null != this.mDocType2ScraperFactory.putIfAbsent(docType, scraperFactory)) {
            throw new RuntimeException("Document type was already registered: " + docType.getTypeName());
        }
    }

    public DocumentType getDocumentType(String typeName) {
        for (DocumentType t : this.mDocType2ScraperFactory.keySet()) {
            if (!t.getTypeName().equals(typeName)) continue;
            return t;
        }
        return DocumentType.UNKNOWN;
    }

    public IDocumentScraperFactory getScraperFactory(DocumentType docType) throws WAImportException {
        IDocumentScraperFactory factory = this.mDocType2ScraperFactory.get(docType);
        if (null == factory) {
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.FILE_TYPE_UNSUPPORTED, new Object[]{docType.getTypeName()}).withConditionCode(EImportMessageCode.FILE_TYPE_UNSUPPORTED).build();
        }
        return factory;
    }

    public DocumentType inferDocumentType(String filename, String mimeType) {
        DocumentType docTypeFromMime = this.inferDocumentTypeFromMime(mimeType);
        DocumentType docTypeFromFilename = this.inferDocumentTypeFromFilename(filename);
        if (!docTypeFromMime.isUnknown()) {
            return docTypeFromMime;
        }
        return docTypeFromFilename;
    }

    private DocumentType inferDocumentTypeFromFilename(String filename) {
        if (!StringUtils.isEmpty((String)filename)) {
            String extension = FilenameUtils.getExtension((String)filename).toLowerCase();
            for (DocumentType t : this.mDocType2ScraperFactory.keySet()) {
                if (!t.getFileExtensions().contains(extension)) continue;
                return t;
            }
        }
        return DocumentType.UNKNOWN;
    }

    private DocumentType inferDocumentTypeFromMime(String mimeType) {
        if (!StringUtils.isEmpty((String)mimeType)) {
            String baseMimeType = mimeType.toLowerCase();
            for (DocumentType t : this.mDocType2ScraperFactory.keySet()) {
                if (!t.getMimeTypes().contains(baseMimeType)) continue;
                return t;
            }
            try {
                ContentType type = ContentType.parse((String)mimeType);
                String[] mimeTypeSplit = type.getMimeType().split("/");
                if (mimeTypeSplit.length == 2) {
                    String subType = mimeTypeSplit[1];
                    int i = subType.lastIndexOf(43);
                    if (i != -1) {
                        subType = subType.substring(i + 1);
                    }
                    baseMimeType = String.format("%s/%s", mimeTypeSplit[0], subType);
                    for (DocumentType t : this.mDocType2ScraperFactory.keySet()) {
                        if (!t.getMimeTypes().contains(baseMimeType)) continue;
                        return t;
                    }
                    subType = mimeTypeSplit[1];
                    if (i != -1) {
                        subType = subType.substring(0, i);
                    }
                    baseMimeType = String.format("%s/%s", mimeTypeSplit[0], subType);
                    for (DocumentType t : this.mDocType2ScraperFactory.keySet()) {
                        if (!t.getMimeTypes().contains(baseMimeType)) continue;
                        return t;
                    }
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return DocumentType.UNKNOWN;
    }

    public ScrapeResult scrapeDocument(String fileName, String mimeType, InputStream input, ScrapeOptions options) throws WAImportException {
        if (null == input) {
            throw new NullArgumentException("input");
        }
        DocumentType docType = this.inferDocumentType(fileName, mimeType);
        if (docType.isUnknown()) {
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.FILE_TYPE_UNKNOWN).withConditionCode(EImportMessageCode.FILE_TYPE_UNKNOWN).build();
        }
        IDocumentScraperFactory factory = this.getScraperFactory(docType);
        IDocumentScraper scraper = factory.create(docType, this);
        return scraper.scrape(fileName, mimeType, input, options);
    }

    public ScrapeResult scrapeDocument(String fileName, String mimeType, File file, ScrapeOptions options) throws WAImportException {
        if (null == file) {
            throw new NullArgumentException("file");
        }
        DocumentType docType = this.inferDocumentType(fileName, mimeType);
        if (docType.isUnknown()) {
            throw WAImportException.newBuilder().withMessage((IMessageKey)NeoImportError.FILE_TYPE_UNKNOWN).withConditionCode(EImportMessageCode.FILE_TYPE_UNKNOWN).build();
        }
        IDocumentScraperFactory factory = this.getScraperFactory(docType);
        IDocumentScraper scraper = factory.create(docType, this);
        try {
            return scraper.scrape(fileName, mimeType, file, options);
        }
        catch (WAImportException ex) {
            WatsonMessageContext msgCtx = ex.getWatsonMessageContext();
            if (msgCtx.getConditionCode() == EImportMessageCode.INVALID_FILE_FORMAT && "excel97".equals(docType.getTypeName())) {
                return this.scrapeDocument(fileName, "application/csv", file, options);
            }
            throw ex;
        }
    }

    public void dispose() {
        if (this.mDisposed) {
            return;
        }
        this.mDisposed = true;
        try {
            this.mSheetLibrary.dispose();
        }
        catch (Exception ex) {
            LOG.error("Failed to dispose of sheet", (Throwable)ex);
        }
        if (this.mSheetDataDir.exists()) {
            FileUtils.deleteQuietly((File)this.mSheetDataDir);
        }
    }

    static {
        new PreInitializeICU4JClasses();
    }
}

