/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.NullArgumentException;

public class DocumentType {
    public static final DocumentType UNKNOWN = new DocumentType("unknown", "unknown", new String[0], new String[0], false, false);
    private final String mTypeName;
    private final String mDescription;
    private final List<String> mFileExtensions;
    private final List<String> mMimeTypes;
    private final boolean mRichDataTypes;
    private final boolean mCompressed;

    public DocumentType(String typeName, String description, String[] fileExtensions, String[] mimeTypes, boolean hasRichDataTypes, boolean isCompressed) {
        if (null == typeName) {
            throw new NullArgumentException("typeName");
        }
        if (null == description) {
            throw new NullArgumentException("description");
        }
        if (null == fileExtensions) {
            throw new NullArgumentException("fileExtensions");
        }
        if (null == mimeTypes) {
            throw new NullArgumentException("mimeTypes");
        }
        this.mTypeName = typeName;
        this.mDescription = description;
        this.mFileExtensions = Collections.unmodifiableList(Arrays.asList(fileExtensions));
        this.mMimeTypes = Collections.unmodifiableList(Arrays.asList(mimeTypes));
        this.mRichDataTypes = hasRichDataTypes;
        this.mCompressed = isCompressed;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public String getTypeName() {
        return this.mTypeName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public List<String> getFileExtensions() {
        return this.mFileExtensions;
    }

    public List<String> getMimeTypes() {
        return this.mMimeTypes;
    }

    public boolean hasRichDataTypes() {
        return this.mRichDataTypes;
    }

    public boolean isCompressed() {
        return this.mCompressed;
    }

    public String toString() {
        return this.mTypeName;
    }

    public int hashCode() {
        return this.mTypeName.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentType)) {
            return false;
        }
        DocumentType other = (DocumentType)o;
        return this.mTypeName.equals(other.mTypeName);
    }
}

