/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.decoration;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.dataimport.cdf.decoration.Decoration;
import com.ibm.neo.dataimport.cdf.decoration.EDecorationType;
import com.ibm.neo.io.VarIntCoder;
import com.ibm.neo.util.JSONUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class AlignmentDecoration
extends Decoration {
    private EHorizontalAlignment mHAlignment = EHorizontalAlignment.GENERAL;
    private EVerticalAlignment mVAlignment = EVerticalAlignment.TOP;
    private int mIndent = 0;

    AlignmentDecoration() {
    }

    public AlignmentDecoration(EHorizontalAlignment hAlignment, EVerticalAlignment vAlignment, int indent) {
        if (null == hAlignment) {
            throw new NullArgumentException("hAlignment");
        }
        if (null == vAlignment) {
            throw new NullArgumentException("vAlignment");
        }
        if (indent < 0) {
            throw new IllegalArgumentException("indent < 0");
        }
        this.mHAlignment = hAlignment;
        this.mVAlignment = vAlignment;
        this.mIndent = indent;
    }

    @Override
    public EDecorationType getDecorationType() {
        return EDecorationType.ALIGNMENT;
    }

    public EHorizontalAlignment getHAlignment() {
        return this.mHAlignment;
    }

    public EVerticalAlignment getVAlignment() {
        return this.mVAlignment;
    }

    public int getIndent() {
        return this.mIndent;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.mHAlignment.ordinal() & 0xFF);
        out.write(this.mVAlignment.ordinal() & 0xFF);
        VarIntCoder.writeUnsignedVarInt((int)this.mIndent, (OutputStream)out);
    }

    @Override
    public void readFrom(InputStream in) throws IOException {
        this.mHAlignment = EHorizontalAlignment.values()[in.read()];
        this.mVAlignment = EVerticalAlignment.values()[in.read()];
        this.mIndent = VarIntCoder.readUnsignedVarInt((InputStream)in);
    }

    @Override
    public void encodeJSON(JSONObject jsonObj) {
        jsonObj.put((Object)"horizontal-alignment", (Object)this.mHAlignment.name());
        jsonObj.put((Object)"vertical-alignment", (Object)this.mVAlignment.name());
        jsonObj.put((Object)"indent", (Object)this.mIndent);
    }

    @Override
    public void decodeJSON(JSONObject jsonObj) {
        this.mHAlignment = EHorizontalAlignment.valueOf(JSONUtils.getString((JSONObject)jsonObj, (Object[])new Object[]{"horizontal-alignment"}));
        this.mVAlignment = EVerticalAlignment.valueOf(JSONUtils.getString((JSONObject)jsonObj, (Object[])new Object[]{"vertical-alignment"}));
        this.mIndent = JSONUtils.getInt((JSONObject)jsonObj, (Object[])new Object[]{"indent"});
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("hAlignment", (Object)this.mHAlignment).append("vAlignment", (Object)this.mVAlignment).append("indent", this.mIndent);
        return builder.toString();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        return builder.append((Object)this.mHAlignment).append((Object)this.mVAlignment).append(this.mIndent).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlignmentDecoration)) {
            return false;
        }
        AlignmentDecoration other = (AlignmentDecoration)o;
        return this.mHAlignment == other.mHAlignment && this.mVAlignment == other.mVAlignment && this.mIndent == other.mIndent;
    }

    public static enum EVerticalAlignment {
        TOP,
        CENTER,
        BOTTOM,
        JUSTIFY;

    }

    public static enum EHorizontalAlignment {
        GENERAL,
        LEFT,
        CENTER,
        RIGHT,
        JUSITFY;

    }
}

