/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.decoration;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.dataimport.cdf.decoration.Decoration;
import com.ibm.neo.dataimport.cdf.decoration.EDecorationType;
import com.ibm.neo.util.JSONUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class BorderDecoration
extends Decoration {
    private EBorderStyle mLeftStyle = EBorderStyle.NONE;
    private EBorderStyle mRightStyle = EBorderStyle.NONE;
    private EBorderStyle mTopStyle = EBorderStyle.NONE;
    private EBorderStyle mBottomStyle = EBorderStyle.NONE;

    BorderDecoration() {
    }

    public BorderDecoration(EBorderStyle leftStyle, EBorderStyle rightStyle, EBorderStyle topStyle, EBorderStyle bottomStyle) {
        if (null == leftStyle) {
            throw new NullArgumentException("leftStyle");
        }
        if (null == rightStyle) {
            throw new NullArgumentException("rightStyle");
        }
        if (null == topStyle) {
            throw new NullArgumentException("topStyle");
        }
        if (null == bottomStyle) {
            throw new NullArgumentException("bottomStyle");
        }
        this.mLeftStyle = leftStyle;
        this.mRightStyle = rightStyle;
        this.mTopStyle = topStyle;
        this.mBottomStyle = bottomStyle;
    }

    @Override
    public EDecorationType getDecorationType() {
        return EDecorationType.BORDER;
    }

    public EBorderStyle getLeftStyle() {
        return this.mLeftStyle;
    }

    public EBorderStyle getRightStyle() {
        return this.mRightStyle;
    }

    public EBorderStyle getTopStyle() {
        return this.mTopStyle;
    }

    public EBorderStyle getBottomStyle() {
        return this.mBottomStyle;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(0xFF & this.mLeftStyle.ordinal());
        out.write(0xFF & this.mRightStyle.ordinal());
        out.write(0xFF & this.mTopStyle.ordinal());
        out.write(0xFF & this.mBottomStyle.ordinal());
    }

    @Override
    public void readFrom(InputStream in) throws IOException {
        this.mLeftStyle = EBorderStyle.values()[in.read()];
        this.mRightStyle = EBorderStyle.values()[in.read()];
        this.mTopStyle = EBorderStyle.values()[in.read()];
        this.mBottomStyle = EBorderStyle.values()[in.read()];
    }

    @Override
    public void encodeJSON(JSONObject jsonObj) {
        jsonObj.put((Object)"left-style", (Object)this.mLeftStyle.name());
        jsonObj.put((Object)"right-style", (Object)this.mRightStyle.name());
        jsonObj.put((Object)"top-style", (Object)this.mTopStyle.name());
        jsonObj.put((Object)"bottom-style", (Object)this.mBottomStyle.name());
    }

    @Override
    public void decodeJSON(JSONObject jsonObj) {
        this.mLeftStyle = EBorderStyle.valueOf(JSONUtils.getString((JSONObject)jsonObj, (Object[])new Object[]{"left-style"}));
        this.mRightStyle = EBorderStyle.valueOf(JSONUtils.getString((JSONObject)jsonObj, (Object[])new Object[]{"right-style"}));
        this.mTopStyle = EBorderStyle.valueOf(JSONUtils.getString((JSONObject)jsonObj, (Object[])new Object[]{"top-style"}));
        this.mBottomStyle = EBorderStyle.valueOf(JSONUtils.getString((JSONObject)jsonObj, (Object[])new Object[]{"bottom-style"}));
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("leftStyle", (Object)this.mLeftStyle).append("rightStyle", (Object)this.mRightStyle).append("topStyle", (Object)this.mTopStyle).append("bottomStyle", (Object)this.mBottomStyle);
        return builder.toString();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.mLeftStyle).append((Object)this.mRightStyle).append((Object)this.mTopStyle).append((Object)this.mBottomStyle);
        return builder.toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BorderDecoration)) {
            return false;
        }
        BorderDecoration other = (BorderDecoration)o;
        EqualsBuilder builder = new EqualsBuilder();
        return builder.append((Object)this.mLeftStyle, (Object)other.mLeftStyle).append((Object)this.mRightStyle, (Object)other.mRightStyle).append((Object)this.mTopStyle, (Object)other.mTopStyle).append((Object)this.mBottomStyle, (Object)other.mBottomStyle).isEquals();
    }

    public static enum EBorderStyle {
        NONE,
        HAIR,
        THIN,
        MEDIUM,
        THICK,
        DOUBLE,
        DASH,
        DOT;

    }
}

