/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.decoration;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.dataimport.cdf.decoration.Decoration;
import com.ibm.neo.dataimport.cdf.decoration.EDecorationType;
import com.ibm.neo.util.JSONUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class CurrencyDecoration
extends Decoration {
    public static final String USE_ISO_CODE_AS_SYMBOL = "***";
    public static final String UNKNOWN_CURRENCY = "\u00a4";
    private String mCurrencyCode = null;
    private String mCurrencySymbol = null;

    CurrencyDecoration() {
    }

    public CurrencyDecoration(String currencyCode, String currencySymbol) {
        this.mCurrencyCode = currencyCode;
        this.mCurrencySymbol = currencySymbol;
    }

    @Override
    public EDecorationType getDecorationType() {
        return EDecorationType.CURRENCY;
    }

    public String getCurrencyCode() {
        return this.mCurrencyCode;
    }

    public String getCurrencySymbol() {
        return this.mCurrencySymbol;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        int flags = (null != this.mCurrencyCode ? 1 : 0) | (null != this.mCurrencySymbol ? 2 : 0);
        dout.write(0xFF & flags);
        if (null != this.mCurrencyCode) {
            dout.writeUTF(this.mCurrencyCode);
        }
        if (null != this.mCurrencySymbol) {
            dout.writeUTF(this.mCurrencySymbol);
        }
        dout.flush();
    }

    @Override
    public void readFrom(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        int flags = din.read();
        this.mCurrencyCode = 1 == (flags & 1) ? din.readUTF() : null;
        this.mCurrencySymbol = 2 == (flags & 2) ? din.readUTF() : null;
    }

    @Override
    public void encodeJSON(JSONObject jsonObj) {
        if (null != this.mCurrencyCode) {
            jsonObj.put((Object)"currency-code", (Object)this.mCurrencyCode);
        }
        if (null != this.mCurrencySymbol) {
            jsonObj.put((Object)"currency-symbol", (Object)this.mCurrencySymbol);
        }
    }

    @Override
    public void decodeJSON(JSONObject jsonObj) {
        this.mCurrencyCode = JSONUtils.getString((JSONObject)jsonObj, (Object[])new Object[]{"currency-code"});
        this.mCurrencySymbol = JSONUtils.getString((JSONObject)jsonObj, (Object[])new Object[]{"currency-symbol"});
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        return builder.append("currencyCode", (Object)this.mCurrencyCode).append("currencySymbol", (Object)this.mCurrencySymbol).toString();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        return builder.append((Object)this.mCurrencyCode).append((Object)this.mCurrencySymbol).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CurrencyDecoration)) {
            return false;
        }
        CurrencyDecoration other = (CurrencyDecoration)o;
        EqualsBuilder builder = new EqualsBuilder();
        return builder.append((Object)this.mCurrencyCode, (Object)other.mCurrencyCode).append((Object)this.mCurrencySymbol, (Object)other.mCurrencySymbol).isEquals();
    }
}

