/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.decoration;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.dataimport.cdf.decoration.Decoration;
import com.ibm.neo.dataimport.cdf.decoration.EDecorationType;
import com.ibm.neo.util.JSONUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class DateTimeFormatDecoration
extends Decoration {
    private Locale mSymbolsLocale = null;
    private String mFormatPattern = null;
    private boolean mHasDateFields = false;
    private boolean mHasTimeFields = false;

    DateTimeFormatDecoration() {
    }

    public DateTimeFormatDecoration(Locale symbolsLocale, String formatPattern, boolean hasDateFields, boolean hasTimeFields) {
        this.mSymbolsLocale = symbolsLocale;
        this.mFormatPattern = formatPattern;
        this.mHasDateFields = hasDateFields;
        this.mHasTimeFields = hasTimeFields;
    }

    @Override
    public EDecorationType getDecorationType() {
        return EDecorationType.DATETIME_FORMAT;
    }

    public Locale getSymbolsLocale() {
        return this.mSymbolsLocale;
    }

    public String getFormatPattern() {
        return this.mFormatPattern;
    }

    public boolean hasDateFields() {
        return this.mHasDateFields;
    }

    public boolean hasTimeFields() {
        return this.mHasTimeFields;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        int flags = (null != this.mSymbolsLocale ? 1 : 0) | (null != this.mFormatPattern ? 2 : 0) | (this.mHasDateFields ? 4 : 0) | (this.mHasTimeFields ? 8 : 0);
        dout.write(flags);
        if (null != this.mSymbolsLocale) {
            dout.writeUTF(this.mSymbolsLocale.toString());
        }
        if (null != this.mFormatPattern) {
            dout.writeUTF(this.mFormatPattern);
        }
        dout.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readFrom(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        int flags = din.read();
        if (1 == (flags & 1)) {
            String localeStr = din.readUTF();
            if (localeStr.contains("_")) {
                String[] parts = localeStr.split("_");
                if (parts.length == 2) {
                    this.mSymbolsLocale = new Locale(parts[0], parts[1]);
                } else {
                    if (parts.length != 3) throw new IOException("Malformed symbols locale: " + localeStr);
                    this.mSymbolsLocale = new Locale(parts[0], parts[1], parts[2]);
                }
            } else {
                this.mSymbolsLocale = new Locale(localeStr);
            }
        } else {
            this.mSymbolsLocale = null;
        }
        this.mFormatPattern = 2 == (flags & 2) ? din.readUTF() : null;
        this.mHasDateFields = 4 == (flags & 4);
        this.mHasTimeFields = 8 == (flags & 8);
    }

    @Override
    public void encodeJSON(JSONObject jsonObj) {
        if (null != this.mSymbolsLocale) {
            jsonObj.put((Object)"symbols-locale", (Object)this.mSymbolsLocale.toString());
        }
        if (null != this.mFormatPattern) {
            jsonObj.put((Object)"format-pattern", (Object)this.mFormatPattern);
        }
        jsonObj.put((Object)"has-date-fields", (Object)this.mHasDateFields);
        jsonObj.put((Object)"has-time-fields", (Object)this.mHasTimeFields);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void decodeJSON(JSONObject jsonObj) {
        if (jsonObj.containsKey((Object)"symbols-locale")) {
            String localeStr = JSONUtils.getString((JSONObject)jsonObj, (Object[])new Object[]{"symbols-locale"});
            if (localeStr.contains("_")) {
                String[] parts = localeStr.split("_");
                if (parts.length == 2) {
                    this.mSymbolsLocale = new Locale(parts[0], parts[1]);
                } else {
                    if (parts.length != 3) throw new RuntimeException("Malformed symbols locale: " + localeStr);
                    this.mSymbolsLocale = new Locale(parts[0], parts[1], parts[2]);
                }
            } else {
                this.mSymbolsLocale = new Locale(localeStr);
            }
        } else {
            this.mSymbolsLocale = null;
        }
        this.mFormatPattern = JSONUtils.getString((JSONObject)jsonObj, (Object[])new Object[]{"format-pattern"});
        this.mHasDateFields = JSONUtils.getBoolean((JSONObject)jsonObj, (Object[])new Object[]{"has-date-fields"});
        this.mHasTimeFields = JSONUtils.getBoolean((JSONObject)jsonObj, (Object[])new Object[]{"has-time-fields"});
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        return builder.append("symbolsLocale", (Object)this.mSymbolsLocale).append("formatPattern", (Object)this.mFormatPattern).append("hasDateFields", this.mHasDateFields).append("hasTimeFields", this.mHasTimeFields).toString();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        return builder.append((Object)this.mSymbolsLocale).append((Object)this.mFormatPattern).append(this.mHasDateFields).append(this.mHasTimeFields).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateTimeFormatDecoration)) {
            return false;
        }
        DateTimeFormatDecoration other = (DateTimeFormatDecoration)o;
        EqualsBuilder builder = new EqualsBuilder();
        return builder.append((Object)this.mSymbolsLocale, (Object)other.mSymbolsLocale).append((Object)this.mFormatPattern, (Object)other.mFormatPattern).append(this.mHasDateFields, other.mHasDateFields).append(this.mHasTimeFields, other.mHasTimeFields).isEquals();
    }
}

