/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.decoration;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.dataimport.cdf.decoration.AlignmentDecoration;
import com.ibm.neo.dataimport.cdf.decoration.BorderDecoration;
import com.ibm.neo.dataimport.cdf.decoration.CurrencyDecoration;
import com.ibm.neo.dataimport.cdf.decoration.DateTimeFormatDecoration;
import com.ibm.neo.dataimport.cdf.decoration.EDecorationType;
import com.ibm.neo.dataimport.cdf.decoration.FillDecoration;
import com.ibm.neo.dataimport.cdf.decoration.FontStyleDecoration;
import com.ibm.neo.dataimport.cdf.decoration.NumberFormatDecoration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.NullArgumentException;

public abstract class Decoration {
    static Decoration create(EDecorationType decorationType) {
        if (null == decorationType) {
            throw new NullArgumentException("decorationType");
        }
        switch (decorationType) {
            case ALIGNMENT: {
                return new AlignmentDecoration();
            }
            case BORDER: {
                return new BorderDecoration();
            }
            case FILL: {
                return new FillDecoration();
            }
            case CURRENCY: {
                return new CurrencyDecoration();
            }
            case DATETIME_FORMAT: {
                return new DateTimeFormatDecoration();
            }
            case NUMBER_FORMAT: {
                return new NumberFormatDecoration();
            }
            case FONT_STYLE: {
                return new FontStyleDecoration();
            }
        }
        throw new IllegalArgumentException("Unsupported decorationType: " + (Object)((Object)decorationType));
    }

    public abstract EDecorationType getDecorationType();

    public abstract void writeTo(OutputStream var1) throws IOException;

    public abstract void readFrom(InputStream var1) throws IOException;

    public abstract void encodeJSON(JSONObject var1);

    public abstract void decodeJSON(JSONObject var1);
}

