/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.decoration;

import com.ibm.neo.dataimport.cdf.decoration.Decoration;
import com.ibm.neo.dataimport.cdf.decoration.EDecorationType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang.ArrayUtils;

public class DecorationMap
implements Iterable<Decoration> {
    private static final EDecorationType[] KEYS = EDecorationType.values();
    private final Decoration[] mDecorations = new Decoration[KEYS.length];

    public DecorationMap() {
    }

    public DecorationMap(Collection<Decoration> decorations) {
        for (Decoration d : decorations) {
            this.insert(d);
        }
    }

    public DecorationMap(Decoration ... decorations) {
        for (Decoration d : decorations) {
            this.insert(d);
        }
    }

    public boolean containsKey(EDecorationType key) {
        return null != this.mDecorations[key.ordinal()];
    }

    public boolean containsValue(Decoration value) {
        return ArrayUtils.contains((Object[])this.mDecorations, (Object)value);
    }

    public int size() {
        int size = 0;
        for (Decoration d : this.mDecorations) {
            if (null == d) continue;
            ++size;
        }
        return size;
    }

    public boolean isEmpty() {
        for (Decoration d : this.mDecorations) {
            if (null == d) continue;
            return false;
        }
        return true;
    }

    public Decoration get(EDecorationType key) {
        return this.mDecorations[key.ordinal()];
    }

    public void remove(EDecorationType key) {
        this.mDecorations[key.ordinal()] = null;
    }

    public void insert(Decoration decoration) {
        this.mDecorations[decoration.getDecorationType().ordinal()] = decoration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DecorationMap)) {
            return false;
        }
        DecorationMap other = (DecorationMap)o;
        return Arrays.equals(this.mDecorations, other.mDecorations);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mDecorations);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        builder.append('[');
        for (Decoration d : this) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(d.toString());
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public Iterator<Decoration> iterator() {
        return new Iter();
    }

    private final class Iter
    implements Iterator<Decoration> {
        private int mCurrentIndex = -1;
        private int mNextIndex = -1;

        private Iter() {
            this.findNext();
        }

        private void findNext() {
            ++this.mNextIndex;
            while (this.mNextIndex < KEYS.length && DecorationMap.this.mDecorations[this.mNextIndex] == null) {
                ++this.mNextIndex;
            }
        }

        @Override
        public boolean hasNext() {
            return this.mNextIndex < KEYS.length;
        }

        @Override
        public Decoration next() {
            if (this.mNextIndex >= KEYS.length) {
                throw new NoSuchElementException();
            }
            this.mCurrentIndex = this.mNextIndex;
            Decoration d = DecorationMap.this.mDecorations[this.mCurrentIndex];
            this.findNext();
            return d;
        }

        @Override
        public void remove() {
            if (-1 == this.mCurrentIndex) {
                throw new IllegalStateException();
            }
            ((DecorationMap)DecorationMap.this).mDecorations[this.mCurrentIndex] = null;
            this.mCurrentIndex = -1;
        }
    }
}

