/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.decoration;

import com.ibm.neo.dataimport.cdf.decoration.Decoration;
import com.ibm.neo.dataimport.cdf.decoration.EDecorationType;
import com.ibm.neo.io.VarIntCoder;
import com.ibm.neo.util.BitMask;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class DecorationPool {
    public static final int NULL_KEY = -1;
    private static final EDecorationType[] ALL_TYPES = EDecorationType.values();
    private static final int NUM_TYPE_BITS = (int)Math.ceil(Math.log(ALL_TYPES.length) / Math.log(2.0));
    private static final int NUM_INDEX_BITS = 32 - NUM_TYPE_BITS;
    private static final int TYPE_MASK = BitMask.fillLow32((int)NUM_TYPE_BITS);
    private static final int INDEX_MASK = BitMask.fillLow32((int)NUM_INDEX_BITS);
    private final TypeSegment[] mSegments = new TypeSegment[ALL_TYPES.length];

    public DecorationPool() {
        for (int i = 0; i < ALL_TYPES.length; ++i) {
            this.mSegments[i] = new TypeSegment(ALL_TYPES[i]);
        }
    }

    public Decoration getDecoration(int key) {
        if (-1 == key) {
            return null;
        }
        int type = DecorationPool.getTypeFromKey(key);
        int index = DecorationPool.getIndexFromKey(key);
        return this.mSegments[type].getDecoration(index);
    }

    public int keyOf(Decoration decoration) {
        int type = decoration.getDecorationType().ordinal();
        TypeSegment seg = this.mSegments[type];
        int index = seg.indexOf(decoration);
        if (-1 == index) {
            return -1;
        }
        return DecorationPool.makeKey(type, index);
    }

    public int keyOfOrInsert(Decoration decoration) {
        int type = decoration.getDecorationType().ordinal();
        TypeSegment seg = this.mSegments[type];
        int index = seg.indexOfOrInsert(decoration);
        return DecorationPool.makeKey(type, index);
    }

    public Decoration internalize(Decoration decoration) {
        int type = decoration.getDecorationType().ordinal();
        return this.mSegments[type].internalize(decoration);
    }

    public void clear() {
        for (int i = 0; i < ALL_TYPES.length; ++i) {
            this.mSegments[i].clear();
        }
    }

    public void writeTo(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.writeTo(out);
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        VarIntCoder.writeUnsignedVarInt((int)ALL_TYPES.length, (OutputStream)out);
        for (int i = 0; i < ALL_TYPES.length; ++i) {
            out.write(0xFF & i);
            this.mSegments[i].writeTo(out);
        }
    }

    public void readFrom(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            this.readFrom(in);
        }
    }

    public void readFrom(InputStream in) throws IOException {
        this.clear();
        int size = VarIntCoder.readUnsignedVarInt((InputStream)in);
        for (int i = 0; i < size; ++i) {
            int type = in.read();
            if (type == -1) {
                throw new EOFException("Unexpected end-of-stream");
            }
            if (type >= ALL_TYPES.length) {
                throw new IOException("Unsupported decoration type: " + type);
            }
            TypeSegment seg = this.mSegments[type];
            seg.readFrom(in);
        }
    }

    private static int makeKey(int type, int index) {
        return (type & TYPE_MASK) << NUM_INDEX_BITS | index & INDEX_MASK;
    }

    private static int getTypeFromKey(int key) {
        return key >> NUM_INDEX_BITS & TYPE_MASK;
    }

    private static int getIndexFromKey(int key) {
        return key & INDEX_MASK;
    }

    private static final class TypeSegment {
        private final EDecorationType mDecorationType;
        private final ArrayList<Decoration> mDecorations = new ArrayList();
        private final HashMap<Decoration, Integer> mDecoration2Index = new HashMap();

        public TypeSegment(EDecorationType decorationType) {
            this.mDecorationType = decorationType;
        }

        public Decoration getDecoration(int index) {
            return this.mDecorations.get(index);
        }

        public int indexOf(Decoration decoration) {
            Integer index = this.mDecoration2Index.get(decoration);
            if (null != index) {
                return index;
            }
            return -1;
        }

        public int indexOfOrInsert(Decoration decoration) {
            Integer index = this.mDecoration2Index.get(decoration);
            if (null != index) {
                return index;
            }
            index = this.mDecoration2Index.size();
            this.mDecoration2Index.put(decoration, index);
            this.mDecorations.add(decoration);
            return index;
        }

        public Decoration internalize(Decoration decoration) {
            Integer existingId = this.mDecoration2Index.get(decoration);
            if (null != existingId) {
                return this.mDecorations.get(existingId);
            }
            Integer newId = this.mDecorations.size();
            this.mDecoration2Index.put(decoration, newId);
            this.mDecorations.add(decoration);
            return decoration;
        }

        public void clear() {
            this.mDecorations.clear();
            this.mDecoration2Index.clear();
        }

        public void writeTo(OutputStream out) throws IOException {
            VarIntCoder.writeUnsignedVarInt((int)this.mDecorations.size(), (OutputStream)out);
            for (Decoration d : this.mDecorations) {
                d.writeTo(out);
            }
        }

        public void readFrom(InputStream in) throws IOException {
            this.clear();
            int size = VarIntCoder.readUnsignedVarInt((InputStream)in);
            for (int i = 0; i < size; ++i) {
                Decoration decoration = Decoration.create(this.mDecorationType);
                decoration.readFrom(in);
                this.mDecoration2Index.put(decoration, i);
                this.mDecorations.add(decoration);
            }
        }
    }
}

