/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.decoration;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.dataimport.cdf.decoration.Decoration;
import com.ibm.neo.dataimport.cdf.decoration.EDecorationType;
import com.ibm.neo.dataimport.cdf.decoration.RGBColor;
import com.ibm.neo.util.IJSONCodable;
import com.ibm.neo.util.JSONUtils;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class FillDecoration
extends Decoration {
    private RGBColor mForegroundColor = new RGBColor(Color.WHITE);
    private RGBColor mBackgroundColor = new RGBColor(Color.WHITE);

    FillDecoration() {
    }

    public FillDecoration(RGBColor foregroundColor, RGBColor backgroundColor) {
        if (null == foregroundColor) {
            throw new NullArgumentException("foregroundColor");
        }
        if (null == backgroundColor) {
            throw new NullArgumentException("backgroundColor");
        }
        this.mForegroundColor = foregroundColor;
        this.mBackgroundColor = backgroundColor;
    }

    public RGBColor getForegroundColor() {
        return this.mForegroundColor;
    }

    public RGBColor getBackgroundColor() {
        return this.mBackgroundColor;
    }

    @Override
    public EDecorationType getDecorationType() {
        return EDecorationType.FILL;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        this.mForegroundColor.writeTo(out);
        this.mBackgroundColor.writeTo(out);
    }

    @Override
    public void readFrom(InputStream in) throws IOException {
        this.mForegroundColor.readFrom(in);
        this.mBackgroundColor.readFrom(in);
    }

    @Override
    public void encodeJSON(JSONObject jsonObj) {
        jsonObj.put((Object)"foreground-color", (Object)JSONUtils.toJSONObject((IJSONCodable)this.mForegroundColor));
        jsonObj.put((Object)"background-color", (Object)JSONUtils.toJSONObject((IJSONCodable)this.mBackgroundColor));
    }

    @Override
    public void decodeJSON(JSONObject jsonObj) {
        this.mForegroundColor.decodeJSON(JSONUtils.getJSONObject((JSONObject)jsonObj, (Object[])new Object[]{"foreground-color"}));
        this.mBackgroundColor.decodeJSON(JSONUtils.getJSONObject((JSONObject)jsonObj, (Object[])new Object[]{"background-color"}));
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        return builder.append("foregroundColor", (Object)this.mForegroundColor).append("backgroundColor", (Object)this.mBackgroundColor).toString();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        return builder.append((Object)this.mForegroundColor).append((Object)this.mBackgroundColor).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FillDecoration)) {
            return false;
        }
        FillDecoration other = (FillDecoration)o;
        EqualsBuilder builder = new EqualsBuilder();
        return builder.append((Object)this.mForegroundColor, (Object)other.mForegroundColor).append((Object)this.mBackgroundColor, (Object)other.mBackgroundColor).isEquals();
    }
}

