/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.decoration;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.dataimport.cdf.decoration.Decoration;
import com.ibm.neo.dataimport.cdf.decoration.EDecorationType;
import com.ibm.neo.dataimport.cdf.decoration.RGBColor;
import com.ibm.neo.io.VarIntCoder;
import com.ibm.neo.util.IJSONCodable;
import com.ibm.neo.util.JSONUtils;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class FontStyleDecoration
extends Decoration {
    private String mFamily = null;
    private int mSize = 0;
    private int mWeight = 400;
    private boolean mItalic = false;
    private boolean mStrikeout = false;
    private EUnderlineStyle mUnderline = EUnderlineStyle.NONE;
    private RGBColor mColor = new RGBColor(Color.BLACK);

    FontStyleDecoration() {
    }

    public FontStyleDecoration(String family, int size, int weight, boolean isItalic, boolean isStrikeout, EUnderlineStyle underline, RGBColor color) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        if (weight < 100) {
            throw new IllegalArgumentException("weight < 100");
        }
        if (weight > 900) {
            throw new IllegalArgumentException("weight > 900");
        }
        if (null == underline) {
            throw new NullArgumentException("underline");
        }
        if (null == color) {
            throw new NullArgumentException("color");
        }
        this.mFamily = family;
        this.mSize = size;
        this.mWeight = weight;
        this.mItalic = isItalic;
        this.mStrikeout = isStrikeout;
        this.mUnderline = underline;
        this.mColor = color;
    }

    @Override
    public EDecorationType getDecorationType() {
        return EDecorationType.FONT_STYLE;
    }

    public String getFamily() {
        return this.mFamily;
    }

    public int getSize() {
        return this.mSize;
    }

    public int getWeight() {
        return this.mWeight;
    }

    public boolean isItalic() {
        return this.mItalic;
    }

    public boolean isStrikeout() {
        return this.mStrikeout;
    }

    public EUnderlineStyle getUnderline() {
        return this.mUnderline;
    }

    public RGBColor getColor() {
        return this.mColor;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        int flags = (null != this.mFamily ? 1 : 0) | (this.mItalic ? 2 : 0) | (this.mStrikeout ? 4 : 0);
        dout.write(flags);
        if (null != this.mFamily) {
            dout.writeUTF(this.mFamily);
        }
        VarIntCoder.writeUnsignedVarInt((int)this.mSize, (OutputStream)dout);
        VarIntCoder.writeUnsignedVarInt((int)this.mWeight, (OutputStream)dout);
        dout.write(0xFF & this.mUnderline.ordinal());
        this.mColor.writeTo(dout);
        dout.flush();
    }

    @Override
    public void readFrom(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        int flags = in.read();
        this.mFamily = 1 == (1 & flags) ? din.readUTF() : null;
        this.mSize = VarIntCoder.readUnsignedVarInt((InputStream)din);
        this.mWeight = VarIntCoder.readUnsignedVarInt((InputStream)din);
        this.mUnderline = EUnderlineStyle.values()[din.read()];
        this.mItalic = 2 == (2 & flags);
        this.mStrikeout = 4 == (4 & flags);
        this.mColor.readFrom(din);
    }

    @Override
    public void encodeJSON(JSONObject jsonObj) {
        if (null != this.mFamily) {
            jsonObj.put((Object)"family", (Object)this.mFamily);
        }
        jsonObj.put((Object)"size", (Object)this.mSize);
        jsonObj.put((Object)"weight", (Object)this.mWeight);
        jsonObj.put((Object)"italic", (Object)this.mItalic);
        jsonObj.put((Object)"strikeout", (Object)this.mStrikeout);
        jsonObj.put((Object)"underline", (Object)this.mUnderline.name());
        jsonObj.put((Object)"color", (Object)JSONUtils.toJSONObject((IJSONCodable)this.mColor));
    }

    @Override
    public void decodeJSON(JSONObject jsonObj) {
        this.mFamily = JSONUtils.getString((JSONObject)jsonObj, (Object[])new Object[]{"family"});
        this.mSize = JSONUtils.getInt((JSONObject)jsonObj, (Object[])new Object[]{"size"});
        this.mWeight = JSONUtils.getInt((JSONObject)jsonObj, (Object[])new Object[]{"weight"});
        this.mItalic = JSONUtils.getBoolean((JSONObject)jsonObj, (Object[])new Object[]{"italic"});
        this.mStrikeout = JSONUtils.getBoolean((JSONObject)jsonObj, (Object[])new Object[]{"strikeout"});
        this.mUnderline = EUnderlineStyle.valueOf(JSONUtils.getString((JSONObject)jsonObj, (Object[])new Object[]{"underline"}));
        this.mColor.decodeJSON(JSONUtils.getJSONObject((JSONObject)jsonObj, (Object[])new Object[]{"color"}));
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        return builder.append("family", (Object)this.mFamily).append("size", this.mSize).append("weight", this.mWeight).append("italic", this.mItalic).append("strikeout", this.mStrikeout).append("underline", (Object)this.mUnderline).append("color", (Object)this.mColor).toString();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        return builder.append((Object)this.mFamily).append(this.mSize).append(this.mWeight).append(this.mItalic).append(this.mStrikeout).append((Object)this.mUnderline).append((Object)this.mColor).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FontStyleDecoration)) {
            return false;
        }
        FontStyleDecoration other = (FontStyleDecoration)o;
        EqualsBuilder builder = new EqualsBuilder();
        return builder.append((Object)this.mFamily, (Object)other.mFamily).append(this.mSize, other.mSize).append(this.mWeight, other.mWeight).append(this.mItalic, other.mItalic).append(this.mStrikeout, other.mStrikeout).append((Object)this.mUnderline, (Object)other.mUnderline).append((Object)this.mColor, (Object)other.mColor).isEquals();
    }

    public static enum EUnderlineStyle {
        NONE,
        SINGLE,
        DOUBLE;

    }
}

