/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.decoration;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.dataimport.cdf.decoration.Decoration;
import com.ibm.neo.dataimport.cdf.decoration.EDecorationType;
import com.ibm.neo.io.VarIntCoder;
import com.ibm.neo.util.JSONUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class NumberFormatDecoration
extends Decoration {
    private Locale mSymbolsLocale = null;
    private String mFormatPattern = null;
    private int mMultiplier = 1;
    private int mPrimaryGroupingSize = 0;
    private int mSecondaryGroupingSize = 0;

    NumberFormatDecoration() {
    }

    public NumberFormatDecoration(Locale symbolsLocale, String formatPattern, int multiplier, int primaryGroupingSize, int secondaryGroupingSize) {
        if (multiplier < 1) {
            throw new IllegalArgumentException("multiplier < 1");
        }
        if (primaryGroupingSize < 0) {
            throw new IllegalArgumentException("primaryGroupingSize < 0");
        }
        if (secondaryGroupingSize < 0) {
            throw new IllegalArgumentException("secondaryGroupingSize < 0");
        }
        if (secondaryGroupingSize > 0 && primaryGroupingSize < 1) {
            throw new IllegalArgumentException("secondaryGroupingSize cannot be non-zero when primaryGroupingSize is zero");
        }
        this.mSymbolsLocale = symbolsLocale;
        this.mFormatPattern = formatPattern;
        this.mMultiplier = multiplier;
        this.mPrimaryGroupingSize = primaryGroupingSize;
        this.mSecondaryGroupingSize = secondaryGroupingSize;
    }

    @Override
    public EDecorationType getDecorationType() {
        return EDecorationType.NUMBER_FORMAT;
    }

    public Locale getSymbolsLocale() {
        return this.mSymbolsLocale;
    }

    public String getFormatPattern() {
        return this.mFormatPattern;
    }

    public int getMultiplier() {
        return this.mMultiplier;
    }

    public int getPrimaryGroupingSize() {
        return this.mPrimaryGroupingSize;
    }

    public int getSecondaryGroupingSize() {
        return this.mSecondaryGroupingSize;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        int flags = (null != this.mSymbolsLocale ? 1 : 0) | (null != this.mFormatPattern ? 2 : 0);
        dout.write(flags);
        if (null != this.mSymbolsLocale) {
            dout.writeUTF(this.mSymbolsLocale.toString());
        }
        if (null != this.mFormatPattern) {
            dout.writeUTF(this.mFormatPattern);
        }
        VarIntCoder.writeUnsignedVarInt((int)this.mMultiplier, (OutputStream)dout);
        VarIntCoder.writeUnsignedVarInt((int)this.mPrimaryGroupingSize, (OutputStream)dout);
        VarIntCoder.writeUnsignedVarInt((int)this.mSecondaryGroupingSize, (OutputStream)dout);
        dout.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readFrom(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        int flags = in.read();
        if (1 == (1 & flags)) {
            String localeStr = din.readUTF();
            if (localeStr.contains("_")) {
                String[] parts = localeStr.split("_");
                if (parts.length == 2) {
                    this.mSymbolsLocale = new Locale(parts[0], parts[1]);
                } else {
                    if (parts.length != 3) throw new IOException("Malformed symbols locale: " + localeStr);
                    this.mSymbolsLocale = new Locale(parts[0], parts[1], parts[2]);
                }
            } else {
                this.mSymbolsLocale = new Locale(localeStr);
            }
        } else {
            this.mSymbolsLocale = null;
        }
        this.mFormatPattern = 2 == (2 & flags) ? din.readUTF() : null;
        this.mMultiplier = VarIntCoder.readUnsignedVarInt((InputStream)din);
        this.mPrimaryGroupingSize = VarIntCoder.readUnsignedVarInt((InputStream)din);
        this.mSecondaryGroupingSize = VarIntCoder.readUnsignedVarInt((InputStream)din);
    }

    @Override
    public void encodeJSON(JSONObject jsonObj) {
        if (null != this.mSymbolsLocale) {
            jsonObj.put((Object)"symbols-locale", (Object)this.mSymbolsLocale.toString());
        }
        if (null != this.mFormatPattern) {
            jsonObj.put((Object)"format-pattern", (Object)this.mFormatPattern);
        }
        jsonObj.put((Object)"multiplier", (Object)this.mMultiplier);
        jsonObj.put((Object)"primary-grouping-size", (Object)this.mPrimaryGroupingSize);
        jsonObj.put((Object)"secondary-grouping-size", (Object)this.mSecondaryGroupingSize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void decodeJSON(JSONObject jsonObj) {
        if (jsonObj.containsKey((Object)"symbols-locale")) {
            String localeStr = JSONUtils.getString((JSONObject)jsonObj, (Object[])new Object[]{"symbols-locale"});
            if (localeStr.contains("_")) {
                String[] parts = localeStr.split("_");
                if (parts.length == 2) {
                    this.mSymbolsLocale = new Locale(parts[0], parts[1]);
                } else {
                    if (parts.length != 3) throw new RuntimeException("Malformed symbols locale: " + localeStr);
                    this.mSymbolsLocale = new Locale(parts[0], parts[1], parts[2]);
                }
            } else {
                this.mSymbolsLocale = new Locale(localeStr);
            }
        } else {
            this.mSymbolsLocale = null;
        }
        this.mFormatPattern = JSONUtils.getString((JSONObject)jsonObj, (Object[])new Object[]{"format-pattern"});
        this.mMultiplier = JSONUtils.getInt((JSONObject)jsonObj, (Object[])new Object[]{"multiplier"});
        this.mPrimaryGroupingSize = JSONUtils.getInt((JSONObject)jsonObj, (Object[])new Object[]{"primary-grouping-size"});
        this.mSecondaryGroupingSize = JSONUtils.getInt((JSONObject)jsonObj, (Object[])new Object[]{"secondary-grouping-size"});
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        return builder.append("symbolsLocale", (Object)this.mSymbolsLocale).append("formatPattern", (Object)this.mFormatPattern).append("multiplier", this.mMultiplier).append("primaryGroupingSize", this.mPrimaryGroupingSize).append("secondaryGroupingSize", this.mSecondaryGroupingSize).toString();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        return builder.append((Object)this.mSymbolsLocale).append((Object)this.mFormatPattern).append(this.mMultiplier).append(this.mPrimaryGroupingSize).append(this.mSecondaryGroupingSize).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumberFormatDecoration)) {
            return false;
        }
        NumberFormatDecoration other = (NumberFormatDecoration)o;
        EqualsBuilder builder = new EqualsBuilder();
        return builder.append((Object)this.mSymbolsLocale, (Object)other.mSymbolsLocale).append((Object)this.mFormatPattern, (Object)other.mFormatPattern).append(this.mMultiplier, other.mMultiplier).append(this.mPrimaryGroupingSize, other.mPrimaryGroupingSize).append(this.mSecondaryGroupingSize, other.mSecondaryGroupingSize).isEquals();
    }
}

