/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.decoration;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.io.VarIntCoder;
import com.ibm.neo.util.IJSONCodable;
import com.ibm.neo.util.JSONUtils;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class RGBColor
implements IJSONCodable {
    private int mValue;

    RGBColor() {
        this.mValue = 0;
    }

    public RGBColor(int red, int green, int blue) {
        this.mValue = (0xFF & red) << 16 | (0xFF & green) << 8 | 0xFF & blue;
    }

    public RGBColor(short red, short green, short blue) {
        this.mValue = (0xFF & red) << 16 | (0xFF & green) << 8 | 0xFF & blue;
    }

    public RGBColor(byte red, byte green, byte blue) {
        this.mValue = red << 16 | green << 8 | blue;
    }

    public RGBColor(int[] rgb) {
        if (null == rgb) {
            throw new NullArgumentException("rgb");
        }
        if (rgb.length != 3) {
            throw new IllegalArgumentException("rgb.length != 3");
        }
        this.mValue = (0xFF & rgb[0]) << 16 | (0xFF & rgb[1]) << 8 | 0xFF & rgb[2];
    }

    public RGBColor(short[] rgb) {
        if (null == rgb) {
            throw new NullArgumentException("rgb");
        }
        if (rgb.length != 3) {
            throw new IllegalArgumentException("rgb.length != 3");
        }
        this.mValue = (0xFF & rgb[0]) << 16 | (0xFF & rgb[1]) << 8 | 0xFF & rgb[2];
    }

    public RGBColor(byte[] rgb) {
        if (null == rgb) {
            throw new NullArgumentException("rgb");
        }
        if (rgb.length != 3) {
            throw new IllegalArgumentException("rgb.length != 3");
        }
        this.mValue = (0xFF & rgb[0]) << 16 | (0xFF & rgb[1]) << 8 | 0xFF & rgb[2];
    }

    public RGBColor(Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue());
    }

    public int getRed() {
        return 0xFF & this.mValue >> 16;
    }

    public int getGreen() {
        return 0xFF & this.mValue >> 8;
    }

    public int getBlue() {
        return 0xFF & this.mValue;
    }

    public Color toColor() {
        return new Color(this.getRed(), this.getGreen(), this.getBlue());
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        return builder.append("red", this.getRed()).append("green", this.getGreen()).append("blue", this.getBlue()).toString();
    }

    public int hashCode() {
        return this.mValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RGBColor)) {
            return false;
        }
        RGBColor other = (RGBColor)o;
        return this.mValue == other.mValue;
    }

    public void writeTo(OutputStream out) throws IOException {
        VarIntCoder.writeUnsignedVarInt((int)this.mValue, (OutputStream)out);
    }

    public void readFrom(InputStream in) throws IOException {
        this.mValue = VarIntCoder.readUnsignedVarInt((InputStream)in);
    }

    public void encodeJSON(JSONObject jsonObj) {
        jsonObj.put((Object)"red", (Object)this.getRed());
        jsonObj.put((Object)"green", (Object)this.getGreen());
        jsonObj.put((Object)"blue", (Object)this.getBlue());
    }

    public void decodeJSON(JSONObject jsonObj) {
        int red = JSONUtils.getInt((JSONObject)jsonObj, (Object[])new Object[]{"red"});
        int green = JSONUtils.getInt((JSONObject)jsonObj, (Object[])new Object[]{"green"});
        int blue = JSONUtils.getInt((JSONObject)jsonObj, (Object[])new Object[]{"blue"});
        this.mValue = (0xFF & red) << 16 | (0xFF & green) << 8 | 0xFF & blue;
    }
}

