/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.paging.caching;

import com.ibm.neo.dataimport.cdf.paging.IPageAppender;
import com.ibm.neo.dataimport.cdf.paging.IPageRandomAccess;
import com.ibm.neo.dataimport.cdf.paging.IPageStore;
import com.ibm.neo.dataimport.cdf.paging.caching.CachingPageStore;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CachingPageAppender
implements IPageAppender {
    private final CachingPageStore mStore;
    private final IPageAppender mAppender;
    private final IPageRandomAccess mCacheAccess;
    private boolean mClosed = false;

    public CachingPageAppender(CachingPageStore store, boolean preserve) throws IOException {
        this.mStore = store;
        this.mAppender = store.getPrimaryStore().openAppender(preserve);
        this.mCacheAccess = store.getCacheStore().openRandomAccess();
    }

    @Override
    public IPageStore getStore() {
        return this.mStore;
    }

    @Override
    public void append(ByteBuffer buf) throws IOException {
        this.mAppender.append(buf);
        buf.rewind();
        this.mCacheAccess.append(buf);
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void flush() throws IOException {
        this.mAppender.flush();
        this.mCacheAccess.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.mClosed = true;
            try {
                this.mAppender.close();
            }
            finally {
                this.mCacheAccess.close();
            }
        }
    }
}

