/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.paging.caching;

import com.ibm.neo.dataimport.cdf.paging.IPageRandomAccess;
import com.ibm.neo.dataimport.cdf.paging.IPageStore;
import com.ibm.neo.dataimport.cdf.paging.caching.CachingPageStore;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CachingPageRandomAccess
implements IPageRandomAccess {
    private final CachingPageStore mStore;
    private final IPageRandomAccess mPrimaryAccess;
    private final IPageRandomAccess mCacheAccess;
    private boolean mClosed = false;

    public CachingPageRandomAccess(CachingPageStore store) throws IOException {
        this.mStore = store;
        this.mPrimaryAccess = this.mStore.getPrimaryStore().openRandomAccess();
        this.mCacheAccess = this.mStore.getCacheStore().openRandomAccess();
    }

    @Override
    public IPageStore getStore() {
        return this.mStore;
    }

    @Override
    public boolean read(long pageIndex, ByteBuffer buf) throws IOException {
        if (this.mCacheAccess.read(pageIndex, buf)) {
            return true;
        }
        if (this.mPrimaryAccess.read(pageIndex, buf)) {
            buf.rewind();
            this.mCacheAccess.write(pageIndex, buf);
            return true;
        }
        return false;
    }

    @Override
    public void write(long pageIndex, ByteBuffer buf) throws IOException {
        this.mPrimaryAccess.write(pageIndex, buf);
        buf.rewind();
        this.mCacheAccess.write(pageIndex, buf);
    }

    @Override
    public void append(ByteBuffer buf) throws IOException {
        this.mPrimaryAccess.append(buf);
        buf.rewind();
        this.mCacheAccess.append(buf);
    }

    @Override
    public void flush() throws IOException {
        this.mPrimaryAccess.flush();
        this.mCacheAccess.flush();
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            try {
                this.mPrimaryAccess.close();
            }
            finally {
                this.mCacheAccess.close();
            }
            this.mClosed = true;
        }
    }
}

