/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.paging.caching;

import com.ibm.neo.dataimport.cdf.paging.IPageRandomAccess;
import com.ibm.neo.dataimport.cdf.paging.IPageReader;
import com.ibm.neo.dataimport.cdf.paging.IPageStore;
import com.ibm.neo.dataimport.cdf.paging.caching.CachingPageStore;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CachingPageReader
implements IPageReader {
    private final CachingPageStore mStore;
    private final IPageReader mPrimaryReader;
    private final IPageRandomAccess mCacheAccess;
    private boolean mClosed = false;

    public CachingPageReader(CachingPageStore store) throws IOException {
        this.mStore = store;
        this.mPrimaryReader = this.mStore.getPrimaryStore().openReader();
        this.mCacheAccess = this.mStore.getCacheStore().openRandomAccess();
    }

    @Override
    public IPageStore getStore() {
        return this.mStore;
    }

    @Override
    public boolean read(long pageIndex, ByteBuffer buf) throws IOException {
        if (this.mCacheAccess.read(pageIndex, buf)) {
            return true;
        }
        if (this.mPrimaryReader.read(pageIndex, buf)) {
            buf.rewind();
            this.mCacheAccess.write(pageIndex, buf);
            return true;
        }
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.mClosed = true;
            this.mPrimaryReader.close();
            this.mCacheAccess.close();
        }
    }
}

