/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.paging.caching;

import com.ibm.neo.dataimport.cdf.paging.IPageAppender;
import com.ibm.neo.dataimport.cdf.paging.IPageRandomAccess;
import com.ibm.neo.dataimport.cdf.paging.IPageReader;
import com.ibm.neo.dataimport.cdf.paging.IPageStore;
import com.ibm.neo.dataimport.cdf.paging.caching.CachingPageAppender;
import com.ibm.neo.dataimport.cdf.paging.caching.CachingPageRandomAccess;
import com.ibm.neo.dataimport.cdf.paging.caching.CachingPageReader;
import java.io.IOException;

public class CachingPageStore
implements IPageStore {
    private final IPageStore mPrimaryStore;
    private final IPageStore mCacheStore;

    public CachingPageStore(IPageStore primaryStore, IPageStore cacheStore) {
        if (!cacheStore.isRandomAccessSupported()) {
            throw new IllegalArgumentException("cacheStore does not support random access");
        }
        this.mPrimaryStore = primaryStore;
        this.mCacheStore = cacheStore;
    }

    IPageStore getPrimaryStore() {
        return this.mPrimaryStore;
    }

    IPageStore getCacheStore() {
        return this.mCacheStore;
    }

    @Override
    public int getPageSize() {
        return this.mPrimaryStore.getPageSize();
    }

    @Override
    public long getPageCount() {
        return this.mPrimaryStore.getPageCount();
    }

    @Override
    public boolean isRandomAccessSupported() {
        return this.mPrimaryStore.isRandomAccessSupported();
    }

    @Override
    public boolean isAppendPreservationSupported() {
        return this.mPrimaryStore.isAppendPreservationSupported();
    }

    @Override
    public IPageAppender openAppender(boolean preserve) throws IOException {
        if (!this.isAppendPreservationSupported() || !preserve) {
            this.mCacheStore.clear();
        }
        return new CachingPageAppender(this, preserve);
    }

    @Override
    public IPageReader openReader() throws IOException {
        return new CachingPageReader(this);
    }

    @Override
    public IPageRandomAccess openRandomAccess() throws IOException {
        return new CachingPageRandomAccess(this);
    }

    @Override
    public void clear() throws IOException {
        this.mPrimaryStore.clear();
        this.mCacheStore.clear();
    }

    @Override
    public void destroy() throws IOException {
        this.mPrimaryStore.destroy();
        this.mCacheStore.destroy();
    }
}

