/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.paging.file;

import com.ibm.neo.dataimport.cdf.paging.IPageAppender;
import com.ibm.neo.dataimport.cdf.paging.IPageStore;
import com.ibm.neo.dataimport.cdf.paging.file.FilePageStore;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FilePageAppender
implements IPageAppender {
    private final FilePageStore mStore;
    private final FileChannel mChannel;
    private boolean mClosed = false;

    public FilePageAppender(FilePageStore store, boolean preserve) throws IOException {
        this.mStore = store;
        this.mChannel = new FileOutputStream(store.getPageFile(), preserve).getChannel();
    }

    @Override
    public IPageStore getStore() {
        return this.mStore;
    }

    @Override
    public void append(ByteBuffer buf) throws IOException {
        int len;
        int pageSize = this.mStore.getPageSize();
        if (buf.remaining() != pageSize) {
            throw new IOException(String.format("Buffer size (%d bytes) is inconsistent with page size (%d bytes).", buf.remaining(), pageSize));
        }
        for (int bytesWritten = 0; bytesWritten < pageSize; bytesWritten += len) {
            len = this.mChannel.write(buf);
        }
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void flush() throws IOException {
        this.mChannel.force(true);
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.mClosed = true;
            this.mChannel.close();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

